/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;

public class JvmServices {
    public static Log logger = LogFactory.getLog(JvmServices.class);

    public static void listSystemProperties() {
        Properties props = System.getProperties();
        props.list(System.out);
    }

    public static String getOperatingSystem() {
        String os = System.getProperty("os.name");
        return os;
    }

    public static String getLinuxDistribution() throws IOException {
        String value;
        File file = new File("/etc/lsb-release");
        if (file.exists() && (value = FileServices.getValueOfKey(file, "DISTRIB_ID")) != null && value.length() > 0) {
            return value;
        }
        file = new File("/etc/redhat-release");
        if (file.exists()) {
            return "RedHat";
        }
        file = new File("/etc/SuSE-release");
        if (file.exists()) {
            return "SUSE";
        }
        return null;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name");
        return os.equalsIgnoreCase("Linux");
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }

    public static boolean isJdk() {
        String jreHome = System.getProperty("java.home");
        File jreHomeDir = new File(jreHome);
        File jdkHomeDir = jreHomeDir.getParentFile();
        if (jdkHomeDir == null) {
            return false;
        }
        String path = FileServices.appendPath(jdkHomeDir, "bin");
        logger.debug((Object)("binPath=" + path));
        File binDir = new File(path);
        path = FileServices.appendPath(jdkHomeDir, "lib");
        File libDir = new File(path);
        path = FileServices.appendPath(jdkHomeDir, "jre");
        File jreDir = new File(path);
        path = FileServices.appendFileName(jdkHomeDir, "src.zip");
        File srcFile = new File(path);
        return binDir.exists() && libDir.exists() && jreDir.exists() && srcFile.exists();
    }

    public static File getTmpDirectory() {
        return new File(System.getProperty("java.io.tmpdir", "/tmp"));
    }

    public static File getJavaHomeDirectory() {
        return new File(System.getProperty("java.home"));
    }

    public static File getJdkHomeDirectory() {
        File jreHomeDir = JvmServices.getJavaHomeDirectory();
        return jreHomeDir.getParentFile();
    }

    public static File getHomeDirectory() {
        return new File(System.getProperty("user.home", "/tmp"));
    }

    public static void checkMemory() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        if (free < 0x1800000L) {
            logger.debug((Object)("Running out of memory: " + free / 0x100000L + "MB left."));
            runtime.gc();
            logger.debug((Object)("Running garbage collection: " + runtime.freeMemory() / 0x100000L + " MB available."));
        }
    }
}

