/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;

public class HashcodeServices {
    public static long createHashcode(String value) {
        if (value == null) {
            return 0L;
        }
        long hc = 0L;
        for (int i = 0; i < value.length(); ++i) {
            hc = (hc * 128L + (long)value.charAt(i)) % 99991L;
        }
        return hc;
    }

    public static long createHashcode2(String value) {
        if (value == null) {
            return 0L;
        }
        long hc = 0L;
        for (int i = 0; i < value.length(); ++i) {
            hc = (65599L * hc + (long)value.charAt(i)) % 102001L;
        }
        return hc;
    }

    public static long createHashcode(String value, int multiplicator, int prim) {
        if (value == null) {
            return 0L;
        }
        long hc = 0L;
        for (int i = 0; i < value.length(); ++i) {
            hc = ((long)multiplicator * hc + (long)value.charAt(i)) % (long)prim;
        }
        return hc;
    }

    public static void main(String[] args) throws Exception {
        String fileName = args[0];
        int multiplicator = Integer.parseInt(args[1]);
        int prim = Integer.parseInt(args[2]);
        System.out.println("Ok");
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String line = reader.readLine();
        int counter = 0;
        HashMap<Long, String> hcMap = new HashMap<Long, String>();
        while (line != null) {
            ++counter;
            long hc = HashcodeServices.createHashcode(line, multiplicator, prim);
            System.out.println("hc=" + hc);
            String value = (String)hcMap.get(new Long(hc));
            if (value == null) {
                hcMap.put(new Long(hc), line);
            } else {
                System.out.println("Doppelter Hashwert f\u00fcr Wert \"" + value + "\" und Wert \"" + line + "\".");
            }
            line = reader.readLine();
        }
        reader.close();
        System.out.println("Anzahl der Eintr\u00e4ge: " + counter);
    }
}

