/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbdoclet.comparator.PathTokenCountComparator;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;

public class FindServices {
    public static void findFileInDirectory(File dir, String dpattern, String fpattern, List<File> list) {
        FindServices.findFileInDirectory(dir, dpattern, fpattern, null, list);
    }

    public static void findFileInDirectory(File dir, String dpattern, String fpattern, ProgressListener listener, List<File> list) {
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        if (dpattern == null) {
            throw new IllegalArgumentException("The argument dpattern must not be null!");
        }
        if (fpattern == null) {
            throw new IllegalArgumentException("The argument fpattern must not be null!");
        }
        if (list == null) {
            throw new IllegalArgumentException("The argument list must not be null!");
        }
        File[] files1 = dir.listFiles();
        Pattern red = Pattern.compile(dpattern, 2);
        Pattern ref = Pattern.compile(fpattern, 2);
        if (files1 == null) {
            return;
        }
        for (int i = 0; i < files1.length; ++i) {
            File file1 = files1[i];
            Matcher dirMatcher = red.matcher(file1.getName());
            if (file1.isDirectory() && dirMatcher.matches()) {
                File[] files2;
                if (listener != null) {
                    listener.progress(new ProgressEvent().setStage(1).setUserObject(file1));
                }
                if ((files2 = file1.listFiles()) != null && files2.length > 0) {
                    for (int j = 0; j < files2.length; ++j) {
                        File file2 = files2[j];
                        Matcher fileMatcher = ref.matcher(file2.getName());
                        if (!file2.isFile() || !fileMatcher.matches()) continue;
                        list.add(file2);
                    }
                }
                FindServices.findFileInDirectory(file1, dpattern, fpattern, listener, list);
                continue;
            }
            if (!file1.isDirectory()) continue;
            if (listener != null) {
                listener.progress(new ProgressEvent().setStage(1).setUserObject(file1));
            }
            FindServices.findFileInDirectory(file1, dpattern, fpattern, listener, list);
        }
    }

    public static void findFile(String path, ArrayList<File> list) {
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        FindServices.findFile(new File(path), null, list);
    }

    public static void findFile(File dir, ArrayList<File> list) {
        FindServices.findFile(dir, null, list);
    }

    public static void findFile(File dir, String fpattern, ArrayList<File> list) {
        FindServices.findFile(dir, fpattern, true, list);
    }

    public static void findFile(File dir, String fpattern, boolean recursive, ArrayList<File> list) {
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        if (list == null) {
            throw new IllegalArgumentException("The argument list must not be null!");
        }
        File[] files = dir.listFiles();
        Pattern ref = null;
        Matcher fileMatcher = null;
        if (fpattern != null) {
            ref = Pattern.compile(fpattern, 2);
        }
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (!recursive) continue;
                FindServices.findFile(file, fpattern, list);
                continue;
            }
            if (ref != null) {
                fileMatcher = ref.matcher(file.getName());
                if (!fileMatcher.matches()) continue;
                list.add(file);
                continue;
            }
            list.add(file);
        }
    }

    public static void findDirectory(File dir, String dpattern, ArrayList<File> list) {
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        if (dpattern == null) {
            throw new IllegalArgumentException("The argument dpattern must not be null!");
        }
        if (list == null) {
            throw new IllegalArgumentException("The argument list must not be null!");
        }
        File[] files = dir.listFiles();
        Pattern red = Pattern.compile(dpattern, 2);
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.isDirectory()) continue;
            Matcher dirMatcher = red.matcher(file.getName());
            if (dirMatcher.matches()) {
                list.add(file);
            }
            FindServices.findDirectory(file, dpattern, list);
        }
        Collections.sort(list, new PathTokenCountComparator());
    }
}

