/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.io.FileSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileSetServices {
    private static Log logger = LogFactory.getLog((String)FileSetServices.class.getName());

    public static void createAntFileSets(Document doc, Element parent, ArrayList<FileSet> fileSetList) throws IOException {
        if (doc == null) {
            throw new IllegalArgumentException("The argument doc may not be null!");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The argument parent may not be null!");
        }
        if (fileSetList == null) {
            throw new IllegalArgumentException("The argument fileSetList may not be null!");
        }
        for (FileSet fileSet : fileSetList) {
            Element elem = FileSetServices.createAntFileSet(doc, parent, fileSet);
            parent.appendChild(elem);
        }
    }

    public static Element createAntFileSet(Document doc, Element parent, FileSet fileSet) {
        if (doc == null) {
            throw new IllegalArgumentException("The argument doc may not be null!");
        }
        if (fileSet == null) {
            throw new IllegalArgumentException("The argument fileSet may not be null!");
        }
        Element elem = null;
        String filter = fileSet.getFilter();
        if (filter == null) {
            filter = "";
        }
        boolean isJavadocParent = false;
        String tagName = parent.getTagName();
        if (tagName != null && tagName.equalsIgnoreCase("javadoc")) {
            isJavadocParent = true;
        }
        logger.debug((Object)("filter type = " + fileSet.getFilterType()));
        File path = fileSet.getQualifiedPath();
        if (path.isFile()) {
            if (parent.getTagName().equals("path")) {
                elem = doc.createElement("pathelement");
                elem.setAttribute("location", fileSet.getRelativePath().getPath());
            } else {
                elem = doc.createElement("fileset");
                elem.setAttribute("dir", path.getParentFile().getPath());
                Element include = doc.createElement("include");
                include.setAttribute("name", path.getName());
                elem.appendChild(include);
            }
        } else {
            switch (fileSet.getFilterType()) {
                case 0: {
                    if (isJavadocParent) {
                        elem = doc.createElement("packageset");
                        elem.setAttribute("dir", fileSet.getDirName());
                        break;
                    }
                    elem = doc.createElement("fileset");
                    elem.setAttribute("dir", fileSet.getDirName());
                    break;
                }
                case 1: {
                    elem = doc.createElement("fileset");
                    elem.setAttribute("dir", fileSet.getDirName());
                    Element include = doc.createElement("include");
                    include.setAttribute("name", fileSet.getFilter());
                    elem.appendChild(include);
                    break;
                }
                case 2: {
                    elem = doc.createElement("fileset");
                    elem.setAttribute("dir", fileSet.getDirName());
                    Element exclude = doc.createElement("exclude");
                    exclude.setAttribute("name", fileSet.getFilter());
                    elem.appendChild(exclude);
                    break;
                }
                case 3: {
                    elem = doc.createElement("dirset");
                    elem.setAttribute("dir", fileSet.getDirName());
                    Element include = doc.createElement("include");
                    include.setAttribute("name", fileSet.getFilter());
                    elem.appendChild(include);
                    break;
                }
                case 4: {
                    elem = doc.createElement("dirset");
                    elem.setAttribute("dir", fileSet.getDirName());
                    Element exclude = doc.createElement("exclude");
                    exclude.setAttribute("name", fileSet.getFilter());
                    elem.appendChild(exclude);
                    break;
                }
                case 5: {
                    if (isJavadocParent) {
                        elem = doc.createElement("packageset");
                        elem.setAttribute("dir", fileSet.getDirName());
                    } else {
                        elem = doc.createElement("fileset");
                        elem.setAttribute("dir", fileSet.getDirName());
                    }
                    Element include = doc.createElement("include");
                    include.setAttribute("name", fileSet.getPackageFilter());
                    elem.appendChild(include);
                    break;
                }
                case 6: {
                    elem = doc.createElement("packageset");
                    elem.setAttribute("dir", fileSet.getDirName());
                    Element exclude = doc.createElement("exclude");
                    exclude.setAttribute("name", fileSet.getPackageFilter());
                    elem.appendChild(exclude);
                }
            }
        }
        if (elem != null && !elem.getTagName().equals("pathelement") && !fileSet.isCaseSensitive()) {
            elem.setAttribute("casesensitive", "false");
        }
        return elem;
    }
}

