/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.CreatePathException;
import org.dbdoclet.DeleteFileException;
import org.dbdoclet.FileAccessDeniedException;
import org.dbdoclet.RenameFileException;
import org.dbdoclet.ServiceException;
import org.dbdoclet.Sfv;
import org.dbdoclet.io.DirectoryFilter;
import org.dbdoclet.io.EndsWithFilter;
import org.dbdoclet.io.MimeType;
import org.dbdoclet.io.StartsWithFilter;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.service.ExecResult;
import org.dbdoclet.service.ExecServices;
import org.dbdoclet.service.FileVisitor;
import org.dbdoclet.service.FindServices;
import org.dbdoclet.service.JvmServices;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.template.TemplateTransformException;
import org.dbdoclet.template.TemplateTransformer;

public class FileServices {
    public static final int ALL = 2;
    public static final int ENDS_WITH = 1;
    public static final String FSEP = System.getProperty("file.separator");
    private static Log logger = LogFactory.getLog(FileServices.class);
    public static final int STARTS_WITH = 0;
    public static final Pattern PATTERN_ABSOLUTE_WINDOWS_PATH = Pattern.compile("^([a-z,A-Z]:|/)/.*$");

    public static String appendFileName(File dir, String filename) {
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        return FileServices.appendFileName(dir.getAbsolutePath(), filename);
    }

    public static String appendFileName(String path1, String filename) {
        if (path1 == null || path1.length() == 0) {
            throw new IllegalArgumentException("The argument path1 must not be null!");
        }
        if (filename == null) {
            throw new IllegalArgumentException("The argument filename must not be null!");
        }
        if (filename.trim().length() == 0) {
            throw new IllegalArgumentException("The argument filename must not be empty!");
        }
        if (!path1.endsWith(File.separator)) {
            path1 = path1 + File.separator;
        }
        if (filename.startsWith(File.separator) && filename.length() > 1) {
            filename = filename.substring(1);
        }
        if (filename.endsWith(File.separator)) {
            throw new IllegalArgumentException("The name of file '" + filename + "' must not end with '" + File.separator + "'!");
        }
        if (filename.length() == 0) {
            throw new IllegalArgumentException("The filename must not be of length 0!");
        }
        return path1 + filename;
    }

    public static String appendPath(File dir1, File dir2) {
        if (dir1 == null) {
            throw new IllegalArgumentException("The argument dir1 must not be null!");
        }
        if (dir2 == null) {
            throw new IllegalArgumentException("The argument dir2 must not be null!");
        }
        return FileServices.appendPath(dir1.getPath(), dir2.getPath());
    }

    public static String appendPath(File dir1, String path2) {
        if (dir1 == null) {
            throw new IllegalArgumentException("The argument dir1 must not be null!");
        }
        if (path2 == null) {
            throw new IllegalArgumentException("The argument path2 must not be null!");
        }
        return FileServices.appendPath(dir1.getPath(), path2);
    }

    public static String appendPath(String path1, String path2) {
        if (path1 == null || path1.length() == 0) {
            throw new IllegalArgumentException("The argument path1 must not be null!");
        }
        if (path2 == null || path2.length() == 0) {
            throw new IllegalStateException("The field path2 must not be null!");
        }
        path1 = path1.replace("/", File.separator);
        path2 = path2.replace("/", File.separator);
        if (!path1.endsWith(File.separator)) {
            path1 = path1 + File.separator;
        }
        if (path2.startsWith(File.separator) && path2.length() > File.separator.length()) {
            path2 = path2.substring(File.separator.length());
        }
        if (!path2.endsWith(File.separator)) {
            path2 = path2 + File.separator;
        }
        return path1 + path2;
    }

    public static void cleanRelatedFiles(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        int index = 1;
        String fileBase = FileServices.getFileBase(file.getCanonicalPath());
        String fileExt = FileServices.getExtension(file.getCanonicalPath());
        logger.debug((Object)("Verzeichnis aufr\u00e4umen: " + file.getCanonicalPath()));
        while (file.exists()) {
            try {
                FileServices.setWritable(file);
                FileServices.delete(file);
            }
            catch (Exception oops) {
                logger.fatal((Object)"FileServices.cleanRelatedFiles", (Throwable)oops);
            }
            String path = fileBase + "-" + String.valueOf(index++);
            if (fileExt != null && fileExt.trim().length() > 0) {
                path = path + "." + fileExt;
            }
            file = new File(path);
            logger.debug((Object)("Verzeichnis aufr\u00e4umen: " + file.getCanonicalPath()));
        }
    }

    public static boolean contains(File file, String regex) throws ServiceException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (regex == null) {
            throw new IllegalArgumentException("The argument regex must not be null!");
        }
        BufferedReader reader = null;
        try {
            String line;
            Pattern pattern = Pattern.compile(regex);
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException oops) {
            throw new ServiceException(oops);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static boolean copyDir(File src, File dest) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("The argument src must not be null!");
        }
        if (dest == null) {
            throw new IllegalArgumentException("The argument dest must not be null!");
        }
        return FileServices.copyDir(src.getCanonicalPath(), dest.getCanonicalPath(), null, null);
    }

    public static boolean copyDir(File src, File dest, Map<String, String> filterSet) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("The argument src must not be null!");
        }
        if (dest == null) {
            throw new IllegalArgumentException("The argument dest must not be null!");
        }
        return FileServices.copyDir(src.getCanonicalPath(), dest.getCanonicalPath(), null, filterSet, null, null);
    }

    public static boolean copyDir(File src, File dest, Pattern includePattern) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("The argument src must not be null!");
        }
        if (dest == null) {
            throw new IllegalArgumentException("The argument dest must not be null!");
        }
        if (includePattern == null) {
            throw new IllegalArgumentException("The argument includePattern must not be null!");
        }
        Pattern[] patterns = new Pattern[]{includePattern};
        return FileServices.copyDir(src.getPath(), dest.getPath(), patterns, null, null, null);
    }

    public static boolean copyDir(File src, String dest, int index) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("The argument src must not be null!");
        }
        return FileServices.copyDir(src.getCanonicalPath(), dest, index);
    }

    public static boolean copyDir(File src, String dest, int index, ProgressListener listener, String resourceString) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("The argument src must not be null!");
        }
        return FileServices.copyDir(src.getCanonicalPath(), dest, index, listener, resourceString);
    }

    public static boolean copyDir(String src, String dest) throws IOException {
        return FileServices.copyDir(src, dest, null, null, null, null);
    }

    public static boolean copyDir(String src, String dest, int index) throws IOException {
        return FileServices.copyDir(src, dest, index, null, null);
    }

    public static boolean copyDir(String src, String dest, int index, ProgressListener listener, String resourceString) throws IOException {
        String path = FileServices.normalizePath(src);
        String name = FileServices.getPathToken(path = StringServices.chop(path, "/"), index);
        if (name == null) {
            throw new FileNotFoundException(src);
        }
        for (int i = index; i > 0; --i) {
            name = FileServices.getPathToken(path, i);
            dest = FileServices.appendPath(dest, name);
            logger.debug((Object)("Anlegen des Verzeichnisses " + dest + "."));
            dest = FileServices.normalizePath(dest);
            FileServices.createPath(dest);
        }
        return FileServices.copyDir(src, dest, null, null, listener, resourceString);
    }

    public static boolean copyDir(String src, String dest, Map<String, String> filterSet) throws IOException {
        return FileServices.copyDir(src, dest, null, filterSet, null, null);
    }

    public static boolean copyDir(String src, String dest, Pattern[] includePatterns) throws IOException {
        return FileServices.copyDir(src, dest, includePatterns, null, null, null);
    }

    public static boolean copyDir(String src, String dest, Pattern[] includePatterns, Map<String, String> filterSet, ProgressListener listener, String resourceString) throws IOException {
        src = FileServices.normalizePath(src);
        dest = FileServices.normalizePath(dest);
        logger.debug((Object)(src + " -> " + dest));
        if (src == null) {
            throw new IllegalArgumentException("Parameter src is null!");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Parameter dest is null!");
        }
        File srcDir = new File(src);
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source path '" + srcDir.getAbsolutePath() + "' dosen't exist!");
        }
        if (!srcDir.isDirectory()) {
            throw new IllegalArgumentException("Source path '" + srcDir.getAbsolutePath() + "' is not a directory!");
        }
        File destDir = FileServices.createPath(dest);
        if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination path '" + destDir.getAbsolutePath() + "' is not a directory!");
        }
        src = FileServices.normalizePath(srcDir.getCanonicalPath());
        dest = FileServices.normalizePath(destDir.getCanonicalPath());
        File[] files = srcDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String destFileName = FileServices.appendFileName(dest, files[i].getName());
            File destFile = new File(destFileName);
            if (files[i].isDirectory()) {
                File newDestDir;
                String newSrc = files[i].getCanonicalPath();
                newSrc = FileServices.normalizePath(newSrc);
                String newDest = StringServices.replace(newSrc, src, dest);
                FileServices.copyDir(newSrc, newDest, includePatterns, filterSet, listener, resourceString);
                if (includePatterns != null && (newDestDir = new File(newDest)).list().length == 0) {
                    FileServices.delete(newDestDir);
                }
            }
            if (includePatterns != null) {
                boolean doCopy = false;
                for (int p = 0; p < includePatterns.length; ++p) {
                    Matcher matcher = includePatterns[p].matcher(destFileName);
                    if (!matcher.matches()) continue;
                    doCopy = true;
                    break;
                }
                if (!doCopy) continue;
            }
            if (!files[i].isFile()) continue;
            if (listener != null) {
                logger.debug((Object)"Firing progress event.");
                String msg = resourceString != null ? MessageFormat.format(resourceString, files[i].getPath(), destFile.getPath()) : files[i].getName();
                if (!listener.progress(new ProgressEvent(msg, false))) {
                    return false;
                }
            }
            logger.debug((Object)(files[i].getAbsolutePath() + " -> " + destFile.getAbsolutePath()));
            if (filterSet == null || FileServices.isBinary(files[i])) {
                FileInputStream in = new FileInputStream(files[i]);
                FileOutputStream out = new FileOutputStream(destFile);
                int n = 0;
                byte[] buffer = new byte[4096];
                while ((n = in.read(buffer, 0, 4096)) != -1) {
                    out.write(buffer, 0, n);
                }
                in.close();
                out.flush();
                out.close();
                if (!destFile.exists()) {
                    throw new IOException("Couldn't create file " + destFileName + "!");
                }
                if (destFile.length() == files[i].length()) continue;
                throw new IOException("Files differ after copy: " + destFileName + "!");
            }
            try {
                TemplateTransformer trafo = TemplateTransformer.newInstance(files[i]);
                trafo.transform(filterSet, destFile);
            }
            catch (TemplateTransformException oops) {
                IOException ioe = new IOException("TemplateTransformException: " + oops.getMessage());
                ioe.initCause(oops);
                ioe.fillInStackTrace();
                throw ioe;
            }
            if (destFile.exists()) continue;
            throw new IOException("Couldn't create file " + destFileName + "!");
        }
        return true;
    }

    public static boolean copyDir(String src, String dest, ProgressListener listener, String resourceString) throws IOException {
        return FileServices.copyDir(src, dest, null, null, listener, resourceString);
    }

    public static void copyFileToDir(File src, File destdir) throws IOException {
        FileServices.copyFileToDir(src.getPath(), destdir.getPath());
    }

    public static void copyFileToDir(String src, String destdir) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("Parameter src is null!");
        }
        File file = new File(src);
        if (!file.exists()) {
            throw new IllegalArgumentException("Parameter src (" + file.getAbsolutePath() + ") can not be found!");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Parameter src (" + file.getAbsolutePath() + ") is not a normal file!");
        }
        if (destdir == null) {
            throw new IllegalArgumentException("Parameter destdir is null!");
        }
        file = new File(destdir);
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("Parameter destdir (" + file.getAbsolutePath() + ") is not a directory!");
        }
        File srcFile = new File(src);
        String path = FileServices.appendFileName(destdir, srcFile.getName());
        File destFile = new File(path);
        FileInputStream in = new FileInputStream(srcFile);
        FileOutputStream out = new FileOutputStream(destFile);
        int n = 0;
        byte[] buffer = new byte[4096];
        while ((n = in.read(buffer, 0, 4096)) != -1) {
            out.write(buffer, 0, n);
        }
        in.close();
        out.close();
    }

    public static void copyFileToFile(File src, File dest) throws IOException {
        FileServices.copyFileToFile(src.getAbsolutePath(), dest.getAbsolutePath(), null);
    }

    public static void copyFileToFile(File srcFile, File destFile, Map<String, String> filterSet) throws IOException {
        if (srcFile == null) {
            throw new IllegalArgumentException("Parameter srcFile is null!");
        }
        if (!srcFile.exists()) {
            throw new IllegalArgumentException("Parameter srcFile doesn't exist! '" + srcFile.getAbsolutePath() + "'");
        }
        if (!srcFile.isFile()) {
            throw new IllegalArgumentException("Parameter srcFile is not a normal file! '" + srcFile.getAbsolutePath() + "'");
        }
        if (destFile == null) {
            throw new IllegalArgumentException("Parameter destFile is null!");
        }
        if (srcFile.exists() && !srcFile.isFile()) {
            throw new IllegalArgumentException("Parameter destFile is not a normal file! '" + srcFile.getAbsolutePath() + "'");
        }
        if (srcFile.equals(destFile)) {
            return;
        }
        if (destFile.exists() && !destFile.canWrite()) {
            throw new FileAccessDeniedException(destFile);
        }
        String srcPath = srcFile.getCanonicalPath();
        srcPath = FileServices.normalizePath(srcPath);
        String destPath = destFile.getCanonicalPath();
        if ((destPath = FileServices.normalizePath(destPath)).equals(srcPath)) {
            logger.warn((Object)("Copy: Files " + srcPath + " and " + destPath + " are identical!"));
            return;
        }
        String destParentDir = destFile.getParent();
        if (destParentDir != null && destParentDir.length() > 0) {
            FileServices.createPath(destParentDir);
        }
        if (filterSet == null || FileServices.isBinary(srcFile)) {
            FileInputStream in = new FileInputStream(srcFile);
            FileOutputStream out = new FileOutputStream(destFile);
            int n = 0;
            byte[] buffer = new byte[4096];
            while ((n = in.read(buffer, 0, 4096)) != -1) {
                out.write(buffer, 0, n);
            }
            in.close();
            out.flush();
            out.close();
        } else {
            try {
                TemplateTransformer trafo = TemplateTransformer.newInstance(srcFile);
                trafo.transform(filterSet, destFile);
            }
            catch (TemplateTransformException oops) {
                IOException ioe = new IOException("TemplateTransformException: " + oops.getMessage());
                ioe.initCause(oops);
                ioe.fillInStackTrace();
                throw ioe;
            }
        }
    }

    public static void copyFileToFile(String src, String dest) throws IOException {
        FileServices.copyFileToFile(new File(src), new File(dest), null);
    }

    public static void copyFileToFile(String src, String dest, Map<String, String> filterSet) throws IOException {
        FileServices.copyFileToFile(new File(src), new File(dest), filterSet);
    }

    public static File createParentDir(File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        File parentDir = dir.getParentFile();
        if (parentDir == null) {
            return null;
        }
        return FileServices.createPath(parentDir);
    }

    public static File createPath(File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        String dirName = dir.getCanonicalPath();
        if (JvmServices.isWindows() && dirName != null && dirName.length() > 255) {
            throw new CreatePathException(dirName, 3);
        }
        if (!(dir.exists() || dir.mkdirs() || dir.exists())) {
            File parent;
            ArrayList<File> pathList = new ArrayList<File>();
            pathList.add(0, dir);
            File next = dir;
            for (parent = dir.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
                pathList.add(0, parent);
                next = parent;
            }
            if (parent != null && parent.exists()) {
                if (!parent.isDirectory()) {
                    throw new CreatePathException(next.getCanonicalPath(), 1);
                }
                if (!parent.canWrite() || !parent.canRead()) {
                    throw new CreatePathException(next.getCanonicalPath(), 2);
                }
            }
            throw new CreatePathException(dir.getCanonicalPath());
        }
        return dir;
    }

    public static File createPath(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Parameter path is null!");
        }
        return FileServices.createPath(new File(path));
    }

    public static File createUniqueFile(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        int index = 1;
        String fileBase = FileServices.getFileBase(file.getCanonicalPath());
        String fileExt = FileServices.getExtension(file.getCanonicalPath());
        while (file.exists()) {
            String path = fileBase + "-" + String.valueOf(index++);
            if (fileExt != null && fileExt.trim().length() > 0) {
                path = path + "." + fileExt;
            }
            file = new File(path);
        }
        return file;
    }

    public static String cutPrefixPathItems(String path, int length) {
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        if (length < 0) {
            throw new IllegalArgumentException("The argument length must not be < 0!");
        }
        String buffer = FileServices.normalizePath(path);
        buffer = StringServices.cutPrefix(buffer, "/");
        while (buffer.endsWith("/")) {
            buffer = StringServices.cutSuffix(buffer, "/");
        }
        int index = buffer.indexOf("/");
        for (int counter = 1; index > 0 && counter < length; ++counter) {
            index = buffer.indexOf("/", index + 1);
        }
        return buffer.substring(index + 1);
    }

    public static int delete(File file) throws IOException {
        if (file == null) {
            return 0;
        }
        return FileServices.delete(file.getPath(), null);
    }

    public static int delete(File file, ProgressListener listener) throws IOException {
        return FileServices.delete(file.getPath(), listener, null);
    }

    public static int delete(File dir, String regexp) throws IOException {
        if (dir == null) {
            return 0;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        FindServices.findFile(dir, regexp, false, fileList);
        for (File file : fileList) {
            FileServices.delete(file);
        }
        return fileList.size();
    }

    public static int delete(String path) throws IOException {
        return FileServices.delete(path, null);
    }

    public static int delete(String path, ProgressListener listener) throws IOException {
        return FileServices.delete(path, listener, null);
    }

    public static int delete(String path, ProgressListener listener, String resourceString) throws IOException {
        return FileServices.delete(new File(path), listener, resourceString);
    }

    public static int delete(File node, ProgressListener listener, String resourceString) throws IOException {
        boolean rc;
        logger.debug((Object)("L\u00f6sche Pfad " + node + "."));
        if (node == null) {
            return 0;
        }
        int counter = 0;
        if (!node.exists()) {
            logger.debug((Object)("Der Pfad " + node.getAbsolutePath() + " existiert nicht!"));
            return 0;
        }
        if (node.isFile() && !(rc = node.delete())) {
            throw new DeleteFileException(node);
        }
        if (node.isDirectory()) {
            File[] list = node.listFiles();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    if (list[i].isDirectory()) {
                        counter += FileServices.delete(list[i].getAbsolutePath(), listener, resourceString);
                        continue;
                    }
                    rc = list[i].delete();
                    if (rc) continue;
                    throw new DeleteFileException(node);
                }
            }
            ++counter;
            if (listener != null) {
                logger.debug((Object)"Firing progress event.");
                String msg = resourceString != null ? MessageFormat.format(resourceString, node.getPath()) : node.getName();
                listener.progress(new ProgressEvent(msg, false));
            }
            if (!(rc = node.delete())) {
                throw new DeleteFileException(node);
            }
        }
        if (node.exists()) {
            throw new DeleteFileException(node);
        }
        return counter;
    }

    public static void delete(String path, String filter, int type) {
        File[] list;
        if (path == null) {
            return;
        }
        File dir = new File(path);
        if (!dir.exists()) {
            return;
        }
        switch (type) {
            case 0: {
                list = dir.listFiles(new StartsWithFilter(filter));
                break;
            }
            case 1: {
                list = dir.listFiles(new EndsWithFilter(filter));
                break;
            }
            case 2: {
                list = dir.listFiles();
                break;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].delete();
        }
    }

    public static void deleteEmptyDirs(File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].isDirectory()) continue;
            FileServices.deleteEmptyDirs(list[i]);
            if (list[i].list().length != 0) continue;
            FileServices.delete(list[i]);
        }
    }

    public static void deleteEmptyDirs(String path) throws IOException {
        FileServices.deleteEmptyDirs(new File(path));
    }

    public static String getAbsoluteDirName(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Parameter filename is null!");
        }
        if (filename.length() == 0) {
            throw new IllegalArgumentException("Parameter filename is null!");
        }
        File file = new File(filename);
        String path = file.getAbsolutePath();
        int index = path.lastIndexOf(File.separator);
        if (index == -1) {
            return ".";
        }
        path = path.substring(0, index);
        return path;
    }

    public static String getDirName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter fileName is null!");
        }
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("Parameter fileName is null!");
        }
        int index = (fileName = StringServices.chop(fileName, File.separator)).lastIndexOf(File.separator);
        if (index == -1) {
            return ".";
        }
        String path = fileName.substring(0, index);
        return path;
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Parameter filename is null!");
        }
        int index = (filename = FileServices.getFileName(filename)).lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        filename = filename.substring(index + 1);
        return filename;
    }

    public static String getFileBase(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        return FileServices.getFileBase(file.getPath());
    }

    public static String getFileBase(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter fileName is null!");
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return fileName;
        }
        fileName = fileName.substring(0, index);
        return fileName;
    }

    public static String getFileName(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter path is null!");
        }
        path = FileServices.normalizePath(path);
        path = StringServices.chop(path, "/");
        File file = new File(path);
        return file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeType(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        String type = null;
        String[] cmd = new String[]{"file", "-b", "-p", "-i", fileName};
        ExecResult result = ExecServices.exec(cmd);
        type = result.getOutput();
        type = StringServices.trim(type, Sfv.LSEP);
        type = StringServices.trim(type, ' ');
        if (!result.failed() && type != null && type.length() > 0) {
            logger.debug((Object)("(file -b -pi -i " + fileName + ") -e type=" + type));
            return type;
        }
        String name = FileServices.getFileName(fileName.toLowerCase());
        name = StringServices.cutSuffix(name, ",v");
        FileNameMap fnm = URLConnection.getFileNameMap();
        type = fnm.getContentTypeFor(name);
        if (type != null && type.trim().length() > 0) {
            logger.debug((Object)("(FileNameMap " + name + ") type=" + type));
            return type;
        }
        String ext = FileServices.getExtension(name);
        MimeType mimeType = MimeType.findByExtension(ext);
        if (mimeType != null) {
            logger.debug((Object)("(MimeType " + name + ") type=" + mimeType.getMimeType()));
            return mimeType.getMimeType();
        }
        File file = new File(fileName);
        boolean nullByte = false;
        if (file.exists() && file.canRead()) {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                int c = reader.read();
                while (c != -1) {
                    c = reader.read();
                    if (c != 0) continue;
                    nullByte = true;
                    break;
                }
            }
            catch (Throwable oops) {
                logger.fatal((Object)"FileServices.isBinary", oops);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException oops) {
                    logger.fatal((Object)"FileServices.isBinary reader.close() ", (Throwable)oops);
                }
            }
        }
        if (nullByte) {
            logger.debug((Object)("(No MimeType Found, Null Byte) " + name + ") type=application/octet-stream"));
            return "application/octet-stream";
        }
        logger.debug((Object)("(No MimeType Found " + name + ") type=text/plain"));
        return "text/plain";
    }

    public static String getPathHead(String path, int length) {
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        if (length < 0) {
            throw new IllegalArgumentException("The argument length must not be < 0!");
        }
        String subPath = path = FileServices.normalizePath(path);
        int index = path.indexOf("/");
        for (int counter = 0; index > 0 && counter < length; ++counter) {
            index = path.indexOf("/", index + 1);
        }
        if (index > 0) {
            subPath = path.substring(0, index);
        }
        return subPath;
    }

    public static String getPathTail(String path, int length) {
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        if (length < 0) {
            throw new IllegalArgumentException("The argument length must not be < 0!");
        }
        String subPath = path = StringServices.replace(path, FSEP, "/");
        int index = path.lastIndexOf("/");
        for (int counter = 1; index > 0 && counter < length; ++counter) {
            index = path.lastIndexOf("/", index - 1);
        }
        if (index > 0) {
            subPath = path.substring(index + 1);
        }
        return subPath;
    }

    public static String getPathToken(String path, int index) {
        int indexStart;
        if (index == 0) {
            return "";
        }
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        if (index < 0) {
            throw new IllegalArgumentException("The argument index must not be < 0!");
        }
        String buffer = FileServices.normalizePath(path);
        buffer = StringServices.chop(buffer, "/");
        logger.debug((Object)("buffer = " + buffer));
        int indexEnd = indexStart = buffer.length();
        for (int i = 0; i < index; ++i) {
            indexEnd = indexStart;
            indexStart = buffer.lastIndexOf(47, indexStart - 1);
            logger.debug((Object)("start = " + indexStart + ", end = " + indexEnd));
            if (indexStart != -1) continue;
            return null;
        }
        String token = buffer.substring(indexStart + 1, indexEnd);
        logger.debug((Object)("path token [" + index + "] = '" + token + "'."));
        return token;
    }

    public static int getPathTokenCount(String path) {
        logger.debug((Object)("#1 path=" + path));
        if (path == null || path.trim().length() == 0) {
            return 0;
        }
        path = FileServices.normalizePath(path);
        path = StringServices.trim(path, '/');
        logger.debug((Object)("#2 path=" + path));
        int index = path.indexOf("/");
        logger.debug((Object)("index=" + index));
        int counter = 1;
        while (index > 0) {
            index = path.indexOf("/", index + 1);
            logger.debug((Object)("index=" + index));
            ++counter;
        }
        logger.debug((Object)("counter=" + counter));
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValueOfKey(File file, String key) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (key == null) {
            throw new IllegalArgumentException("The argument key must not be null!");
        }
        if (!(key = key.trim()).endsWith("=")) {
            key = key + "=";
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(key)) continue;
                if (line.length() <= key.length()) {
                    String string = "";
                    return string;
                }
                String string = line.substring(key.length() + 1);
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static boolean hasSubdirectory(File dir, String name) {
        if (dir == null) {
            return false;
        }
        if (name == null || name.length() == 0) {
            return false;
        }
        String[] listing = dir.list();
        if (listing == null) {
            return false;
        }
        for (int i = 0; i < listing.length; ++i) {
            if (!name.equals(listing[i])) continue;
            return true;
        }
        return false;
    }

    public static String info(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("path=" + file.getCanonicalPath());
        if (!file.exists()) {
            buffer.append(",exists=false");
            return buffer.toString();
        }
        buffer.append(",size=" + file.length());
        return buffer.toString();
    }

    public static boolean isAbsolutePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        String buffer = new String(path);
        buffer = StringServices.replace(buffer, File.separator, "/");
        if ((buffer = buffer.toLowerCase()).startsWith("/")) {
            return true;
        }
        return JvmServices.isWindows() && PATTERN_ABSOLUTE_WINDOWS_PATH.matcher(buffer).matches();
    }

    public static boolean isBinary(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        return FileServices.isBinary(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBinary(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        String mimeType = FileServices.getMimeType(fileName);
        logger.debug((Object)("mimeType=" + mimeType));
        if (mimeType.startsWith("image/")) {
            return true;
        }
        if (mimeType.startsWith("video/")) {
            return true;
        }
        if (mimeType.startsWith("audio/")) {
            return true;
        }
        if (mimeType.equals("application/octet-stream") || mimeType.equals("application/pdf") || mimeType.equals("application/postscript") || mimeType.equals("application/x-cpio") || mimeType.equals("application/x-dvi") || mimeType.equals("application/x-gtar") || mimeType.equals("application/x-tar") || mimeType.equals("application/x-ustar") || mimeType.equals("application/x-troff-msvideo") || mimeType.equals("application/zip")) {
            return true;
        }
        File file = new File(fileName);
        boolean nullByte = false;
        if (file.exists() && file.canRead()) {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                int c = reader.read();
                while (c != -1) {
                    c = reader.read();
                    if (c != 0) continue;
                    nullByte = true;
                    break;
                }
            }
            catch (Throwable oops) {
                logger.fatal((Object)"FileServices.isBinary", oops);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException oops) {
                    logger.fatal((Object)"FileServices.isBinary reader.close() ", (Throwable)oops);
                }
            }
        }
        return nullByte;
    }

    public static boolean isEmptyDirectory(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        File[] list = file.listFiles();
        return list.length == 0;
    }

    public static void move(String src, String destdir) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("The argument src must not be null!");
        }
        if (destdir == null) {
            throw new IllegalArgumentException("The argument destdir must not be null!");
        }
        File srcFile = new File(src);
        File destFile = new File(destdir + File.separator + srcFile.getName());
        if (srcFile.equals(destFile)) {
            return;
        }
        boolean rc = srcFile.renameTo(destFile);
        if (!rc) {
            throw new RenameFileException(srcFile, destFile);
        }
    }

    public static boolean newer(File f1, File f2) {
        if (f1 == null || !f1.exists()) {
            return false;
        }
        if (f2 == null || !f2.exists()) {
            return true;
        }
        return f1.lastModified() >= f2.lastModified();
    }

    public static boolean newer(String f1, String f2) {
        return FileServices.newer(new File(f1), new File(f2));
    }

    public static String normalizePath(String path) {
        String buffer;
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        path = new String(path);
        File file = new File(path);
        path = path.trim();
        path = StringServices.replace(path, File.separator, "/");
        while (FileServices.isAbsolutePath(path) && path.length() > 1 && FileServices.isAbsolutePath(buffer = path.substring(1))) {
            path = buffer;
        }
        if (FileServices.isAbsolutePath(path)) {
            path = StringServices.lowerFirstLetter(path);
        }
        if (file.exists() && file.isDirectory() && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static String pkgToPath(String pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("The argument pkg must not be null!");
        }
        String path = StringServices.replace(pkg, ".", File.separator);
        return path;
    }

    public static String readLine(File file, int lineIndex) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (lineIndex < 0) {
            throw new IllegalArgumentException("The argument lineIndex must not be < 0!");
        }
        int count = 0;
        if (file != null && file.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                if (count == lineIndex) {
                    reader.close();
                    return line;
                }
                line = reader.readLine();
                ++count;
            }
            reader.close();
        }
        return null;
    }

    public static Object[] readToArray(File file) throws IOException {
        return FileServices.readToArray(file, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] readToArray(File file, String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The argument encoding must not be null!");
        }
        Object[] array = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));){
            ArrayList<String> list = new ArrayList<String>();
            String line2 = reader.readLine();
            while (line2 != null) {
                list.add(line2);
                line2 = reader.readLine();
            }
            int index = 0;
            array = new Object[list.size()];
            for (String line2 : list) {
                array[index++] = line2;
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readToByteArray(File file) throws IOException {
        int length;
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        int off = 0;
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            logger.error((Object)"The file is too big (>2147483647)!");
            fis.close();
            return null;
        }
        int size = length = (int)fileLength;
        byte[] buffer = new byte[length];
        try {
            int count;
            while ((count = fis.read(buffer, off, size)) != -1) {
                if (length - (off += count) < size && (size = length - off) < 1) {
                    break;
                }
                if (off < 0) {
                    logger.error((Object)("Argument off must not be negative: off=" + off + ", count=" + count + ", len=" + size + ", b.length=" + length));
                }
                if (size < 0) {
                    logger.error((Object)("Argument len must not be negative: off=" + off + ", count=" + count + ", len=" + size + ", b.length=" + length));
                }
                if (size <= length - off) continue;
                logger.error((Object)("Argument len must not be negative: off=" + off + ", count=" + count + ", len=" + size + ", b.length=" + length));
            }
        }
        finally {
            fis.close();
        }
        return buffer;
    }

    public static String readToString(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        return FileServices.readToString(file, "UTF-8");
    }

    public static String readToString(File file, String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        FileInputStream fis = new FileInputStream(file);
        String buffer = FileServices.readToString(fis, encoding);
        fis.close();
        return buffer;
    }

    public static String readToString(InputStream is) throws IOException {
        return FileServices.readToString(is, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(InputStream is, String encoding) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("The argument is must not be null!");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The argument encoding must not be null!");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuffer buffer = new StringBuffer();
        char[] data = new char[4096];
        try {
            int count;
            while ((count = reader.read(data)) > 0) {
                buffer.append(data, 0, count);
            }
        }
        finally {
            reader.close();
        }
        return buffer.toString();
    }

    public static String readToString(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        return FileServices.readToString(new File(fileName), "UTF-8");
    }

    public static String readToString(String fileName, String encoding) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        return FileServices.readToString(new File(fileName), encoding);
    }

    public static String relativePath(File start, File dest) throws IOException {
        if (start == null) {
            throw new IllegalArgumentException("The argument start must not be null!");
        }
        if (dest == null) {
            throw new IllegalArgumentException("The argument dest must not be null!");
        }
        File from = new File(start.getCanonicalPath());
        File to = new File(dest.getCanonicalPath());
        logger.debug((Object)("Berechne relativen Pfad von " + from + " zu " + to + ".\n"));
        if (from.equals(to)) {
            return ".";
        }
        File file = to;
        String downPath = "";
        String upPath = "";
        File fromParent = from;
        if (fromParent.isFile()) {
            fromParent = fromParent.getParentFile();
        }
        while (fromParent != null) {
            String path1 = fromParent.getCanonicalPath() + File.separator;
            String path2 = to.getCanonicalPath();
            logger.debug((Object)("path1 = " + path1));
            logger.debug((Object)("path2 = " + path2));
            if (path2.startsWith(path1)) {
                String str = StringServices.cutPrefix(path2, path1);
                if (downPath.length() == 0) {
                    downPath = "." + File.separator;
                }
                str = FileServices.appendPath(downPath, str);
                String relativePath = StringServices.chop(str, File.separator);
                return relativePath;
            }
            downPath = downPath + ".." + File.separator;
            if (file != null) {
                upPath = file.getName() + File.separator + upPath;
            }
            if ((fromParent = fromParent.getParentFile()).getParent() == null) break;
            if (file == null) continue;
            file = file.getParentFile();
        }
        return dest.getCanonicalPath();
    }

    public static String removeParentPath(File dir, File parentDir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        if (parentDir == null) {
            throw new IllegalArgumentException("The argument parentDir must not be null!");
        }
        String parentPath = parentDir.getCanonicalPath();
        if (!parentPath.endsWith(Sfv.FSEP)) {
            parentPath = parentPath + Sfv.FSEP;
        }
        return FileServices.removeParentPath(dir.getCanonicalPath(), parentPath);
    }

    public static String removeParentPath(String path, String parentPath) {
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        if (parentPath == null) {
            throw new IllegalArgumentException("The argument parentPath must not be null!");
        }
        path = FileServices.normalizePath(path);
        parentPath = FileServices.normalizePath(parentPath);
        logger.debug((Object)("path=" + path));
        logger.debug((Object)("parentPath=" + parentPath));
        path = StringServices.cutPrefix(path, parentPath);
        return path;
    }

    public static void rename(File srcFile, File destFile) throws IOException {
        if (srcFile == null) {
            throw new IllegalArgumentException("The argument srcFile must not be null!");
        }
        if (destFile == null) {
            throw new IllegalArgumentException("The argument destFile must not be null!");
        }
        if (srcFile.equals(destFile)) {
            logger.warn((Object)("Source file " + srcFile + " is identical to destination file."));
            return;
        }
        boolean rc = srcFile.renameTo(destFile);
        if (rc) {
            return;
        }
        if (srcFile.isDirectory()) {
            FileServices.copyDir(srcFile, destFile);
            FileServices.delete(srcFile);
            return;
        }
        throw new RenameFileException(srcFile, destFile);
    }

    public static String replaceExtension(File file, String extension) {
        return FileServices.replaceExtension(file.getPath(), extension);
    }

    public static String replaceExtension(String fileName, String extension) {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        if (extension == null) {
            throw new IllegalArgumentException("The argument extension must not be null!");
        }
        String base = FileServices.getFileBase(fileName);
        return base + extension;
    }

    public static boolean setReadOnly(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        String[] cmd = null;
        ExecResult result = null;
        try {
            if (JvmServices.isUnix()) {
                cmd = file.isDirectory() ? new String[]{"find", file.getCanonicalPath(), "-exec", "chmod", "a-w", "{}", ";"} : new String[]{"chmod", "a-w", file.getCanonicalPath()};
            }
            if (JvmServices.isWindows()) {
                cmd = new String[]{"attrib", "+r", "+h", file.getCanonicalPath()};
                if (file.isDirectory()) {
                    result = ExecServices.exec(cmd);
                    if (result.failed()) {
                        IOException oops = new IOException(result.toString());
                        throw oops;
                    }
                    cmd = new String[]{"attrib", "+r", "+h", file.getCanonicalPath() + "\\*.*", "/S", "/D"};
                }
            }
            if (cmd == null) {
                logger.error((Object)("Operating System '" + JvmServices.getOperatingSystem() + "' is not supported!"));
                return false;
            }
            logger.debug((Object)("Executing command '" + StringServices.arrayToString(cmd) + "'..."));
            result = ExecServices.exec(cmd);
            if (result.failed()) {
                logger.error((Object)result.toString());
                return false;
            }
        }
        catch (IOException oops) {
            logger.fatal((Object)("setReadOnly failed! (" + StringServices.arrayToString(cmd) + ")"), (Throwable)oops);
            return false;
        }
        return true;
    }

    public static boolean setReadOnly(String path) {
        if (path == null) {
            return false;
        }
        return FileServices.setReadOnly(new File(path));
    }

    public static boolean setWritable(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        String[] cmd = null;
        ExecResult result = null;
        try {
            if (JvmServices.isUnix()) {
                cmd = file.isDirectory() ? new String[]{"find", file.getCanonicalPath(), "-exec", "chmod", "a+w", "{}", ";"} : new String[]{"chmod", "a+w", file.getCanonicalPath()};
            }
            if (JvmServices.isWindows()) {
                cmd = new String[]{"attrib", "-r", "-h", file.getCanonicalPath()};
                if (file.isDirectory()) {
                    result = ExecServices.exec(cmd);
                    if (result.failed()) {
                        IOException oops = new IOException(result.toString());
                        throw oops;
                    }
                    cmd = new String[]{"attrib", "-r", "-h", file.getCanonicalPath() + "\\*.*", "/S", "/D"};
                }
            }
            if (cmd == null) {
                logger.error((Object)("Operating System '" + JvmServices.getOperatingSystem() + "' is not supported!"));
                return false;
            }
            logger.debug((Object)("Executing command '" + StringServices.arrayToString(cmd) + "'..."));
            result = ExecServices.exec(cmd);
            if (result.failed()) {
                logger.error((Object)result.toString());
                return false;
            }
        }
        catch (IOException oops) {
            logger.fatal((Object)("setWritable failed! (" + StringServices.arrayToString(cmd) + ")"), (Throwable)oops);
            return false;
        }
        return true;
    }

    public static boolean setWritable(File file, String caller) {
        logger.debug((Object)("Caller of setWritable is '" + caller + "'."));
        return FileServices.setWritable(file);
    }

    public static boolean setWritable(String path) {
        if (path == null) {
            return false;
        }
        return FileServices.setWritable(new File(path));
    }

    public static boolean setWritable(String path, String caller) {
        logger.debug((Object)("Caller of setWritable is '" + caller + "'."));
        return FileServices.setWritable(path);
    }

    public static void sort(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        Object[] array = FileServices.readToArray(file);
        Arrays.sort(array);
        FileServices.writeFromArray(file, array);
    }

    public static void touch(File file) throws IOException {
        FileServices.writeFromString(file, String.valueOf(System.currentTimeMillis()));
    }

    public static void touch(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        FileServices.touch(new File(fileName));
    }

    public static String toWindowsPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        String winPath = path;
        Pattern winDrivePattern = Pattern.compile("^/[a-cA-Z]:/");
        Matcher matcher = winDrivePattern.matcher(winPath);
        if (matcher.lookingAt()) {
            winPath = winPath.substring(1);
        }
        winPath = winPath.trim();
        winPath = StringServices.replace(winPath, "/", "\\");
        return winPath;
    }

    public static String correctPathSeperator(String in) {
        String os = System.getProperty("os.name");
        in = FileServices.normalizePath(in);
        if (os.toLowerCase().contains("windows")) {
            in = FileServices.toWindowsPath(in);
            return in;
        }
        return in;
    }

    public static void traverse(File dir, FileVisitor visitor) {
        if (dir == null || !dir.exists() || visitor == null) {
            return;
        }
        for (File file : dir.listFiles()) {
            visitor.visit(file);
        }
        File[] subdirs = dir.listFiles(new DirectoryFilter());
        if (subdirs != null) {
            for (File subdir : subdirs) {
                FileServices.traverse(subdir, visitor);
            }
        }
    }

    public static void write(File file, InputStream instr) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (instr == null) {
            throw new IllegalArgumentException("The argument instr must not be null!");
        }
        File parent = file.getParentFile();
        if (parent != null) {
            FileServices.createPath(parent);
        }
        FileOutputStream out = new FileOutputStream(file);
        int n = 0;
        byte[] buffer = new byte[4096];
        while ((n = instr.read(buffer, 0, 4096)) != -1) {
            out.write(buffer, 0, n);
        }
        out.flush();
        out.close();
    }

    public static void writeFromArray(File file, Object[] array) throws IOException {
        FileServices.writeFromArray(file, array, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFromArray(File file, Object[] array, String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (array == null) {
            throw new IllegalArgumentException("The argument array must not be null!");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The argument encoding must not be null!");
        }
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));){
            for (int i = 0; i < array.length; ++i) {
                writer.println(array[i]);
            }
        }
    }

    public static void writeFromByteArray(File file, byte[] buffer) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("The argument buffer must not be null!");
        }
        FileOutputStream out = new FileOutputStream(file);
        out.write(buffer);
        out.close();
    }

    public static void writeFromStream(String fileName, InputStream instr) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        if (instr == null) {
            throw new IllegalArgumentException("The argument instr must not be null!");
        }
        FileOutputStream out = new FileOutputStream(fileName);
        int n = 0;
        byte[] buffer = new byte[4096];
        while ((n = instr.read(buffer, 0, 4096)) != -1) {
            out.write(buffer, 0, n);
        }
        out.close();
    }

    public static void writeFromString(File file, String str) throws IOException {
        FileServices.writeFromString(file, str, "UTF-8");
    }

    public static void writeFromString(File file, String str, String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            FileServices.createPath(parent);
        }
        FileOutputStream fos = new FileOutputStream(file);
        FileServices.writeFromString(fos, str, encoding);
        fos.close();
    }

    public static void writeFromString(OutputStream os, String str) throws IOException {
        FileServices.writeFromString(os, str, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFromString(OutputStream os, String str, String encoding) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("The argument os must not be null!");
        }
        if (str == null) {
            throw new IllegalArgumentException("The argument str must not be null!");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The argument encoding must not be null!");
        }
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, encoding));){
            writer.print(str);
        }
    }

    public static void writeFromString(String fileName, String str) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        FileServices.writeFromString(new File(fileName), str);
    }

    public static void writeFromString(String fileName, String str, String encoding) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        FileServices.writeFromString(new File(fileName), str, encoding);
    }
}

