/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.progress.InfoListener;
import org.dbdoclet.service.ArrayServices;
import org.dbdoclet.service.ExecResult;
import org.dbdoclet.service.JvmServices;
import org.dbdoclet.service.StdInput;
import org.dbdoclet.service.StringServices;

public class ExecServices {
    private static Log logger = LogFactory.getLog(ExecServices.class);

    public static void sleep(int secs) {
        try {
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException oops) {
            oops.printStackTrace();
        }
    }

    public static ExecResult exec(String cmd) {
        return ExecServices.exec(cmd, new File("."), false, null);
    }

    public static ExecResult exec(String cmd, InfoListener listener) {
        return ExecServices.exec(cmd, new File("."), false, listener);
    }

    public static ExecResult exec(String cmd, File workDir, InfoListener listener) {
        return ExecServices.exec(cmd, workDir, false, listener);
    }

    public static ExecResult exec(String cmd, boolean background) {
        return ExecServices.exec(cmd, new File("."), background, null);
    }

    public static ExecResult exec(String cmd, File workDir, boolean background) {
        return ExecServices.exec(cmd, workDir, background, null);
    }

    public static ExecResult exec(String cmd, File workDir, boolean background, InfoListener listener) {
        if (cmd == null) {
            throw new IllegalArgumentException("The argument cmd may not be null!");
        }
        if (workDir == null) {
            workDir = new File(".");
        }
        StringTokenizer stz = new StringTokenizer(cmd);
        ArrayList<String> cmdList = new ArrayList<String>();
        while (stz.hasMoreTokens()) {
            String token = stz.nextToken();
            if (token.startsWith("-") && token.endsWith("\"")) {
                token = StringServices.cut(token, "\"");
                token = StringServices.cutSuffix(token, "\"");
            }
            if (token.startsWith("\"")) {
                while (stz.hasMoreTokens() && !(token = token + " " + stz.nextToken()).endsWith("\"")) {
                }
            }
            token = StringServices.trim(token, '\"');
            cmdList.add(token);
        }
        String[] cmdArray = ArrayServices.listToStringArray(cmdList);
        for (int i = 0; i < cmdArray.length; ++i) {
            logger.debug((Object)("cmdArray[" + i + "]=" + cmdArray[i]));
        }
        return ExecServices.exec(cmdArray, null, workDir, background, listener);
    }

    public static ExecResult exec(String[] cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("The argument cmd may not be null!");
        }
        return ExecServices.exec(cmd, null, null, false);
    }

    public static ExecResult exec(String[] cmd, boolean background) {
        if (cmd == null) {
            throw new IllegalArgumentException("The argument cmd may not be null!");
        }
        return ExecServices.exec(cmd, null, null, background);
    }

    public static ExecResult exec(String[] cmd, String path) {
        if (cmd == null) {
            throw new IllegalArgumentException("The argument cmd may not be null!");
        }
        if (path == null) {
            throw new IllegalArgumentException("The argument path may not be null!");
        }
        return ExecServices.exec(cmd, null, new File(path), false);
    }

    public static ExecResult exec(String[] cmd, String[] envp, File dir) {
        return ExecServices.exec(cmd, envp, dir, false);
    }

    public static ExecResult exec(String[] cmd, String[] envp, File dir, boolean background) {
        return ExecServices.exec(cmd, envp, dir, background, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecResult exec(String[] cmd, String[] envp, File dir, boolean background, InfoListener listener) {
        if (cmd == null) {
            throw new IllegalArgumentException("The argument cmd may not be null!");
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("Executing \"");
        for (int i = 0; i < cmd.length; ++i) {
            buffer.append("'");
            buffer.append(cmd[i]);
            buffer.append("' ");
        }
        buffer.append("\"");
        logger.info((Object)buffer.toString());
        Process process = null;
        int exitCode = 0;
        ExecResult result = new ExecResult();
        result.setCommand(StringServices.arrayToString(cmd));
        StdInput stdout = null;
        StdInput stderr = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            if (envp == null && dir == null) {
                process = runtime.exec(cmd);
            }
            if (envp == null && dir != null) {
                process = runtime.exec(cmd, envp, dir);
            }
            if (envp != null && dir == null) {
                dir = new File(".");
                process = runtime.exec(cmd, envp, dir);
            }
            if (envp != null && dir != null) {
                process = runtime.exec(cmd, envp, dir);
            }
            result.setProcess(process);
            stdout = new StdInput(process.getInputStream(), listener, result);
            stderr = new StdInput(process.getErrorStream(), listener, result);
            stdout.start();
            stderr.start();
            if (!background) {
                process.waitFor();
                stdout.join(10000L);
                stderr.join(10000L);
            }
        }
        catch (Throwable oops) {
            result.setThrowable(oops);
            result.setExitCode(-1);
        }
        finally {
            if (!background) {
                try {
                    logger.info((Object)"Closing Stdout and Stderr...");
                    if (stdout != null) {
                        stdout.close();
                    }
                    if (stderr != null) {
                        stderr.close();
                    }
                    if (process != null) {
                        exitCode = process.exitValue();
                        result.setExitCode(exitCode);
                    } else {
                        result.setExitCode(-1);
                    }
                }
                catch (IllegalThreadStateException itse) {
                    process.destroy();
                }
            }
        }
        return result;
    }

    public static ExecResult open(File file) throws IOException {
        String[] cmd;
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        ExecResult result = null;
        String path = file.getCanonicalPath();
        if (JvmServices.isWindows()) {
            cmd = file.isDirectory() ? new String[]{"explorer", path} : new String[]{"cmd", "/c", path};
            result = ExecServices.exec(cmd);
        }
        if (JvmServices.isUnix()) {
            String desktopSession = System.getProperty("desktop.session");
            if (desktopSession != null && desktopSession.equalsIgnoreCase("gnome")) {
                cmd = new String[]{"gnome-open", path};
                result = ExecServices.exec(cmd);
            } else if (desktopSession != null && desktopSession.equalsIgnoreCase("kde")) {
                cmd = new String[]{"kfmclient", "newTab", path};
                result = ExecServices.exec(cmd);
            } else {
                cmd = new String[]{"gnome-open", path};
                result = ExecServices.exec(cmd);
                if (result.failed()) {
                    cmd = new String[]{"kfmclient", "newTab", path};
                    result = ExecServices.exec(cmd);
                }
            }
        }
        return result;
    }

    public static void invokeInfoViewer(final InfoListener viewer, final InputStream instr) {
        if (viewer == null) {
            throw new IllegalArgumentException("The argument viewer must not be null!");
        }
        if (instr == null) {
            throw new IllegalArgumentException("The argument instr must not be null!");
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(instr));
                    String line = reader.readLine();
                    while (line != null) {
                        viewer.info(line);
                        line = reader.readLine();
                    }
                }
                catch (Exception oops) {
                    oops.printStackTrace();
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
            }
        };
        t.start();
    }
}

