/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExecResult {
    private Process process;
    private String command;
    private StringBuffer output = new StringBuffer();
    private Throwable oops = null;
    private int exitCode = -1;

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setOutput(StringBuffer output) {
        this.output = output;
    }

    public void appendOutput(StringBuffer buffer) {
        this.output.append(buffer);
    }

    public void appendOutput(String buffer) {
        this.output.append(buffer);
    }

    public String getOutput() {
        return this.output.toString();
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setThrowable(Throwable oops) {
        this.oops = oops;
    }

    public Throwable getThrowable() {
        return this.oops;
    }

    public String getStackTrace() {
        if (this.oops == null) {
            return "";
        }
        StringWriter buffer = new StringWriter();
        this.oops.printStackTrace(new PrintWriter(buffer));
        return buffer.toString();
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean failed() {
        return this.exitCode != 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Command '" + this.command + "' failed!\n");
        buffer.append("Exit Code: ");
        buffer.append(this.exitCode);
        buffer.append('\n');
        buffer.append("Console Output: ");
        buffer.append(this.output);
        buffer.append('\n');
        if (this.oops != null) {
            buffer.append("Stacktrace: ");
            buffer.append(this.getStackTrace());
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

