/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.progress;

import java.util.ArrayList;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.progress.StageProgressListener;

public class ProgressManager {
    private final ArrayList<ProgressListener> listeners;

    public ProgressManager(ArrayList<ProgressListener> listeners) {
        this.listeners = listeners;
        if (listeners == null) {
            listeners = new ArrayList();
        }
    }

    public ProgressManager(ProgressListener listener) {
        this.listeners = new ArrayList();
        this.listeners.add(listener);
    }

    public void setProgressMaximum(int max) {
        for (ProgressListener listener : this.listeners) {
            listener.setProgressMaximum(max);
        }
    }

    public void setStageCount(int stageCount) {
        for (ProgressListener listener : this.listeners) {
            if (!(listener instanceof StageProgressListener)) continue;
            ((StageProgressListener)listener).setStageCount(stageCount);
        }
    }

    public void nextStage() {
        for (ProgressListener listener : this.listeners) {
            if (!(listener instanceof StageProgressListener)) continue;
            ((StageProgressListener)listener).nextStage();
        }
    }

    public boolean fireProgressEvent(ProgressEvent event) {
        boolean rc = true;
        if (this.listeners != null) {
            for (ProgressListener listener : this.listeners) {
                if (listener.progress(event)) continue;
                rc = false;
            }
        }
        return rc;
    }

    public void finished(String text) {
        for (ProgressListener listener : this.listeners) {
            if (!(listener instanceof StageProgressListener)) continue;
            ((StageProgressListener)listener).finished(text);
        }
    }
}

