/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.progress;

import org.dbdoclet.progress.ReportItem;

public class DefaultReportItem
implements ReportItem {
    public static final int SUCCESS = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    private int status = 0;
    private Throwable cause;
    private Object item;
    private String msg;

    public DefaultReportItem(Object item, int status) {
        this(item, status, null, null);
    }

    public DefaultReportItem(Object item, int status, String msg) {
        this(item, status, msg, null);
    }

    public DefaultReportItem(Object item, int status, String msg, Throwable cause) {
        if (item == null) {
            throw new IllegalArgumentException("The argument item must not be null!");
        }
        if (status != 1 && status != 3 && status != 2) {
            throw new IllegalArgumentException("The argument status is invalid!");
        }
        this.item = item;
        this.status = status;
        this.msg = msg;
        this.cause = cause;
    }

    @Override
    public boolean isSuccess() {
        return this.status == 1;
    }

    @Override
    public boolean isError() {
        return this.status == 3;
    }

    @Override
    public boolean isWarning() {
        return this.status == 2;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        return this.msg;
    }

    @Override
    public Object getItem() {
        return this.item;
    }

    @Override
    public String getSubject() {
        return this.toString();
    }

    public String toString() {
        if (this.item != null) {
            return this.item.toString();
        }
        return "???";
    }
}

