/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.option;

import java.io.File;
import java.util.StringTokenizer;
import org.dbdoclet.option.Option;
import org.dbdoclet.option.OptionType;

public class PathOption
extends Option<String> {
    private String invalidPathElement = "";

    public PathOption() {
        this.hasArgument(true);
    }

    public PathOption(String longName) {
        super(longName);
        this.hasArgument(true);
    }

    public PathOption(String longName, String shortName) {
        super(longName, shortName);
        this.hasArgument(true);
    }

    @Override
    public void addValueFromString(String value) {
        this.addValue(value);
    }

    public String getInvalidPathElement() {
        return this.invalidPathElement;
    }

    @Override
    public void setValueFromString(String value) {
        this.setValue(value);
    }

    @Override
    protected boolean checkArgument(String arg) {
        if (arg == null) {
            throw new IllegalArgumentException("The argument arg may not be null!");
        }
        StringTokenizer stz = new StringTokenizer(arg, System.getProperty("path.separator"));
        while (stz.hasMoreTokens()) {
            File path;
            String token = stz.nextToken();
            String pathElement = token;
            if (pathElement.startsWith("~")) {
                pathElement = pathElement.equals("~") ? System.getProperty("user.home") : System.getProperty("user.home") + pathElement.substring(1);
            }
            if ((path = new File(pathElement)).exists()) continue;
            this.invalidPathElement = pathElement;
            return false;
        }
        return true;
    }

    @Override
    public OptionType getType() {
        return OptionType.TEXT;
    }
}

