/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.option;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import org.dbdoclet.option.BooleanOption;
import org.dbdoclet.option.DirectoryOption;
import org.dbdoclet.option.FileOption;
import org.dbdoclet.option.Option;
import org.dbdoclet.option.OptionException;
import org.dbdoclet.option.PathOption;
import org.dbdoclet.option.SelectOption;
import org.dbdoclet.option.StringOption;
import org.dbdoclet.service.ResourceServices;

public class OptionList
implements Iterable<Option<?>> {
    private static ResourceBundle res = Option.getResourceBundle();
    private ArrayList<String> remainingArgs;
    private ArrayList<String> args;
    private ArrayList<Option<?>> optList;
    private HashMap<String, Option<?>> optMap;
    private HashMap<String, Option<?>> deprecatedPropertiesMap;
    private String error = "";

    public OptionList() {
        String[] args = new String[]{};
        this.init(args, 0);
    }

    public OptionList(String[][] cmdline) {
        String[] args = (String[])Arrays.stream(cmdline).flatMap(arr -> Arrays.stream(arr)).toArray(String[]::new);
        this.init(args, 0);
    }

    public OptionList(String[] cmdline) {
        if (cmdline == null) {
            throw new IllegalArgumentException("Variable args is null!");
        }
        this.init(cmdline, 0);
    }

    public OptionList(String[] cmdline, int offset) {
        if (cmdline == null) {
            throw new IllegalArgumentException("The argument cmdline may not be null!");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("The argument offset must be greater than 0!");
        }
        if (offset > cmdline.length) {
            throw new IllegalArgumentException("The argument offset is greater than the lehgth of the command line!");
        }
        this.init(cmdline, offset);
    }

    public String getError() {
        if (this.error == null) {
            this.error = "";
        }
        return String.join((CharSequence)" ", this.args) + "\n\n" + this.error;
    }

    public Option<?> findOption(Option<?> option) {
        Option<?> obj;
        int index = this.optList.indexOf(option);
        if (index != -1 && (obj = this.optList.get(index)) != null && obj instanceof Option) {
            return obj;
        }
        return null;
    }

    public Option<?> findOption(String name) {
        if (name == null) {
            throw new IllegalArgumentException(" The argument name may not be null!");
        }
        return this.optMap.get(name);
    }

    public Option<?> findExistingOption(Option<?> option) {
        if (option == null) {
            throw new IllegalArgumentException(" The argument option may not be null!");
        }
        Option<?> existing = this.optMap.get(option.getLongName());
        if (existing != null) {
            return existing;
        }
        existing = this.optMap.get(option.getMediumName());
        if (existing != null) {
            return existing;
        }
        existing = this.optMap.get(option.getShortName());
        if (existing != null) {
            return existing;
        }
        existing = this.optMap.get(option.getPropertyName());
        if (existing != null) {
            return existing;
        }
        throw new OptionException("Can't find existing option!");
    }

    public Option<?> getOption(String name) throws OptionException {
        if (name == null) {
            throw new IllegalArgumentException("The argument name may not be null!");
        }
        Option<?> option = this.optMap.get(name);
        if (option == null) {
            String msg = MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_UNKNOWN"), name);
            throw new OptionException(msg);
        }
        return option;
    }

    public BooleanOption getBooleanOption(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name may not be null!");
        }
        Option<?> option = this.getOption(name);
        if (option instanceof BooleanOption) {
            return (BooleanOption)option;
        }
        String msg = MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_INVALID_TYPE"), name, "boolean", option.getClass().getName());
        throw new OptionException(msg);
    }

    public void add(Option<?> option) throws OptionException {
        if (option == null) {
            throw new IllegalArgumentException(" The argument option may not be null!");
        }
        if (!option.isValid()) {
            throw new OptionException(ResourceServices.getString(res, "C_ERROR_INVALID_OPTION") + option.getUniqueName());
        }
        if (this.exists(option)) {
            Option<?> existing = this.findExistingOption(option);
            throw new OptionException(MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_ALREADY_IN_USE"), option.getFQName(), existing.getFQName()));
        }
        this.optList.add(option);
        Arrays.stream(option.getNames()).forEach(n -> this.optMap.put((String)n, option));
    }

    public String[] getRemainingArgs() {
        if (this.remainingArgs == null) {
            return new String[0];
        }
        return (String[])this.remainingArgs.stream().toArray(String[]::new);
    }

    public String getString(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Variable name is null!");
        }
        Option<?> option = this.optMap.get(name);
        if (option == null) {
            return "";
        }
        if (option.getValue() == null) {
            return null;
        }
        return option.getValue().toString();
    }

    public String getString(String name, String deflt) {
        if (name == null) {
            throw new IllegalArgumentException("Variable name is null!");
        }
        Option<?> option = this.optMap.get(name);
        if (option == null || option.isUnset()) {
            return deflt;
        }
        if (option.getValue() == null) {
            return deflt;
        }
        return option.getValue().toString();
    }

    public void addDeprecatedPropertyAlias(Option<?> option, String alias) throws OptionException {
        Option<?> opt;
        if (option == null) {
            throw new IllegalArgumentException("The argument option may not be null!");
        }
        if (alias == null || alias.length() == 0 || alias.equals("!")) {
            throw new IllegalArgumentException("The argument alias is invalid: " + alias);
        }
        if (this.deprecatedPropertiesMap == null) {
            throw new IllegalStateException(" The field deprecatedPropertiesMap may not be null!");
        }
        String name = alias;
        if (name.startsWith("!")) {
            name = name.substring(1);
        }
        if ((opt = this.optMap.get(name)) != null && !opt.equals(option)) {
            throw new OptionException(MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_ALREADY_IN_USE"), name));
        }
        this.deprecatedPropertiesMap.put(alias, option);
    }

    public boolean setProperties(String fname) throws FileNotFoundException, IOException {
        if (fname == null) {
            throw new IllegalArgumentException(" The argument fname may not be null!");
        }
        Properties props = new Properties();
        props.load(new FileInputStream(fname));
        return this.setProperties(props);
    }

    public boolean setProperties(Properties props) throws OptionException {
        if (props == null) {
            throw new IllegalArgumentException(" The argument props may not be null!");
        }
        String buffer = "";
        for (Object obj : props.keySet()) {
            String name;
            String value;
            if (!(obj instanceof String) || (value = props.getProperty(name = (String)obj)) == null) continue;
            Option<?> option = this.optMap.get(name);
            if (option == null) {
                option = this.deprecatedPropertiesMap.get(name);
                if (option != null) {
                    buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_WARN_PROPERTY_DEPRECATED"), name, option.getPropertyName()) + "\n";
                } else {
                    option = this.deprecatedPropertiesMap.get("!" + name);
                    if (option != null && option instanceof BooleanOption) {
                        value = value.trim();
                        boolean flag = false;
                        if (value.equals("1") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("ja") || value.equalsIgnoreCase("wahr")) {
                            flag = true;
                        }
                        ((BooleanOption)option).setValue(flag);
                        continue;
                    }
                }
            }
            if (option == null) {
                buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_PROPERTY_UNKNOWN"), name) + "\n";
                continue;
            }
            if (option == null || !option.isUnset()) continue;
            option.setValueFromString(value);
        }
        if (buffer != null && buffer.length() > 0) {
            this.error = buffer;
            return false;
        }
        return true;
    }

    public boolean validate() {
        return this.validate(false);
    }

    public boolean validate(boolean ignoreUnknownOptions) throws OptionException {
        Iterator<Option<?>> iterator = this.optList.iterator();
        String buffer = "";
        int index = -1;
        int counter = 0;
        ArrayList<String> argList = new ArrayList<String>(this.args);
        while (iterator.hasNext()) {
            Option<?> option = iterator.next();
            option.isUnset(true);
            index = this.searchArgs(argList, option);
            if (index == -1 && option.isRequired()) {
                buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_REQUIRED"), option.getUniqueName()) + "\n";
                continue;
            }
            counter = 0;
            while (index != -1) {
                if (option.hasArgument()) {
                    DirectoryOption diropt;
                    FileOption fileopt;
                    PathOption pathopt;
                    SelectOption selopt;
                    if (index == argList.size() - 1) {
                        buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_NEEDS_ARG"), option.getUniqueName()) + "\n";
                        argList.remove(index);
                        index = this.searchArgs(argList, option);
                        continue;
                    }
                    String arg = argList.get(index + 1);
                    if (arg.startsWith("-")) {
                        buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_NEEDS_ARG"), option.getUniqueName()) + "\n";
                        argList.remove(index);
                        index = this.searchArgs(argList, option);
                        continue;
                    }
                    if (option instanceof SelectOption && !(selopt = (SelectOption)option).checkArgument(arg)) {
                        buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_INVALID_VALUE"), option.getUniqueName(), arg, selopt.getListAsString()) + "\n";
                        argList.remove(index + 1);
                        argList.remove(index);
                        index = this.searchArgs(argList, option);
                        continue;
                    }
                    if (option instanceof PathOption && !(pathopt = (PathOption)option).checkArgument(arg)) {
                        buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_INVALID_PATH"), option.getUniqueName(), arg, pathopt.getInvalidPathElement()) + "\n";
                        argList.remove(index + 1);
                        argList.remove(index);
                        index = this.searchArgs(argList, option);
                        continue;
                    }
                    if (option instanceof FileOption && !(fileopt = (FileOption)option).checkArgument(arg)) {
                        buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_INVALID_FILE"), option.getUniqueName(), arg) + "\n";
                        argList.remove(index + 1);
                        argList.remove(index);
                        index = this.searchArgs(argList, option);
                        continue;
                    }
                    if (option instanceof DirectoryOption && !(diropt = (DirectoryOption)option).checkArgument(arg)) {
                        buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_INVALID_DIRECTORY"), option.getUniqueName(), arg) + "\n";
                        argList.remove(index + 1);
                        argList.remove(index);
                        index = this.searchArgs(argList, option);
                        continue;
                    }
                    if (option.isLowerCase()) {
                        arg = arg.toLowerCase();
                    }
                    if (option.isUnset() || option.isUnique()) {
                        option.setValueFromString(arg);
                    } else {
                        option.addValueFromString(arg);
                    }
                    option.isPresent(true);
                    argList.remove(index + 1);
                    argList.remove(index);
                    if (!option.isUnique()) {
                        int i;
                        for (i = 0; i < argList.size() && !(arg = argList.get(i)).startsWith("-"); ++i) {
                            option.addValueFromString(arg);
                        }
                        for (int j = 0; j < i; ++j) {
                            argList.remove(0);
                        }
                    }
                } else {
                    String next;
                    String value = "true";
                    if (index + 1 < argList.size() && !(next = argList.get(index + 1)).startsWith("-")) {
                        value = next;
                        argList.remove(index + 1);
                    }
                    option.setValueFromString(value);
                    option.isPresent(true);
                    argList.remove(index);
                }
                index = this.searchArgs(argList, option);
                if (option.isUnique() && index != -1 && counter == 0) {
                    buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_WAS_FOUND_MORE_THAN_ONCE"), option.getUniqueName()) + "\n";
                }
                ++counter;
            }
        }
        if (argList.size() > 0 && !ignoreUnknownOptions) {
            String str = "";
            for (int i = 0; i < argList.size(); ++i) {
                str = str + argList.get(i) + " ";
            }
            buffer = buffer + MessageFormat.format(ResourceServices.getString(res, "C_ERROR_OPTION_UNKNOWN"), str) + "\n";
        }
        this.remainingArgs = new ArrayList<String>(argList);
        if (buffer != null && buffer.length() > 0) {
            this.error = buffer;
            return false;
        }
        return true;
    }

    public void write(PrintWriter writer) {
        Object[] options = this.optList.toArray();
        Arrays.sort(options);
        for (int i = 0; i < options.length; ++i) {
            Option option = (Option)options[i];
            String name = option.getPropertyName();
            if (option.getValue() == null || name == null || name.length() <= 0) continue;
            writer.println(option.getPropertyName() + "=" + this.escape(option.getValue().toString()));
        }
    }

    @Override
    public Iterator<Option<?>> iterator() {
        return this.optList.iterator();
    }

    public String list() {
        StringBuffer buffer = new StringBuffer();
        Object[] options = this.optList.toArray();
        Arrays.sort(options);
        for (int i = 0; i < options.length; ++i) {
            buffer.append(((Option)options[i]).toString() + "\n");
        }
        return buffer.toString();
    }

    private void init(String[] cmdline, int offset) {
        if (cmdline == null) {
            throw new IllegalArgumentException("The argument cmdline may not be null!");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("The argument offset must be greater than 0!");
        }
        if (offset > cmdline.length) {
            throw new IllegalArgumentException("The argument offset is greater than the length of the command line!");
        }
        this.args = new ArrayList();
        for (int i = offset; i < cmdline.length; ++i) {
            String arg = cmdline[i];
            int pos = arg.indexOf(61);
            if (arg.startsWith("--") && pos > 0) {
                this.args.add(arg.substring(0, pos));
                if (pos + 1 < arg.length()) {
                    this.args.add(arg.substring(pos + 1));
                    continue;
                }
                this.args.add("");
                continue;
            }
            this.args.add(cmdline[i]);
        }
        this.optList = new ArrayList();
        this.optMap = new HashMap();
        this.deprecatedPropertiesMap = new HashMap();
    }

    private int searchArgs(ArrayList<String> args, Option<?> option) {
        if (args == null) {
            throw new IllegalArgumentException(" The argument args may not be null!");
        }
        if (option == null) {
            throw new IllegalArgumentException(" The argument option may not be null!");
        }
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (!arg.equals("--" + option.getLongName()) && !arg.equals("-" + option.getMediumName()) && !arg.equals("-" + option.getShortName())) continue;
            return i;
        }
        return -1;
    }

    private boolean exists(Option<?> lookFor) {
        if (this.optList.contains(lookFor)) {
            return true;
        }
        if (!this.isOptionNameAvailable(lookFor.getLongName())) {
            return true;
        }
        if (!this.isOptionNameAvailable(lookFor.getMediumName())) {
            return true;
        }
        if (!this.isOptionNameAvailable(lookFor.getShortName())) {
            return true;
        }
        return !this.isOptionNameAvailable(lookFor.getPropertyName());
    }

    private boolean isOptionNameAvailable(String name) {
        return name == null || name.length() <= 0 || this.optMap.get(name) == null;
    }

    private String escape(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c;
            char n = c = str.charAt(i);
            if (c == '\r') continue;
            if (n >= '\u0000' && n < '\u0080' && c != '\n' && c != '\\') {
                buffer.append(c);
                continue;
            }
            buffer.append("\\u");
            String hex = Integer.toHexString(n);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                buffer.append("0");
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    public boolean getFlag(String name, boolean def) {
        Option<?> option = this.optMap.get(name);
        if (option != null && option instanceof BooleanOption) {
            return (Boolean)((BooleanOption)option).getValue();
        }
        return def;
    }

    public Option<String> getTextOption(String name) {
        Option<?> option = this.getOption(name);
        if (option instanceof SelectOption) {
            return (SelectOption)option;
        }
        if (option instanceof StringOption) {
            return (StringOption)option;
        }
        return null;
    }
}

