/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.option;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.dbdoclet.option.OptionType;
import org.dbdoclet.service.FileServices;

public abstract class Option<T>
implements Comparable<Option<?>> {
    private static ResourceBundle res = ResourceBundle.getBundle("org.dbdoclet.option.Resources");
    private String longName;
    private String shortName;
    private String mediumName;
    private String propertyName;
    private ArrayList<T> values = new ArrayList();
    private boolean isPresent = false;
    private boolean isRequired = false;
    private boolean isUnique = true;
    private boolean hasArgument = false;
    private boolean isLowerCase = false;
    private boolean isUnset = true;

    public Option() {
        this.longName = "";
        this.shortName = "";
        this.mediumName = "";
        this.propertyName = "";
        this.values = new ArrayList();
    }

    public Option(String longName) {
        if (longName == null) {
            throw new IllegalArgumentException("Variable longName is null!");
        }
        this.longName = longName;
        this.shortName = "";
        this.mediumName = "";
        this.propertyName = "";
        this.values = new ArrayList();
    }

    public Option(String longName, String shortName) {
        if (longName == null) {
            throw new IllegalArgumentException("Variable longName is null!");
        }
        if (shortName == null) {
            throw new IllegalArgumentException("Variable shortName is null!");
        }
        this.longName = longName;
        this.shortName = shortName;
        this.mediumName = "";
        this.propertyName = "";
        this.values = new ArrayList();
    }

    public static ResourceBundle getResourceBundle() {
        return res;
    }

    public abstract void addValueFromString(String var1);

    public void addValue(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Variable value is null!");
        }
        this.values.add(value);
        this.isUnset = false;
    }

    @Override
    public int compareTo(Option<?> other) {
        if (other == null) {
            return 1;
        }
        String name = this.getFQName();
        return name.compareTo(other.getFQName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Option) {
            Option option = (Option)obj;
            if (!this.isValid()) {
                return false;
            }
            if (!option.isValid()) {
                return false;
            }
            if (this.longName.equals(option.getLongName()) && this.mediumName.equals(option.getMediumName()) && this.shortName.equals(option.getShortName()) && this.propertyName.equals(option.getPropertyName())) {
                return true;
            }
        }
        return false;
    }

    public String getFQName() {
        String buffer = "(";
        if (this.propertyName != null && this.propertyName.length() > 0) {
            if (buffer.length() > 0) {
                buffer = buffer + ".";
            }
            buffer = buffer + this.propertyName;
        }
        if (this.longName != null && this.longName.length() > 0) {
            if (buffer.length() > 0) {
                buffer = buffer + "/";
            }
            buffer = buffer + this.longName;
        }
        if (this.mediumName != null && this.mediumName.length() > 0) {
            if (buffer.length() > 0) {
                buffer = buffer + "/";
            }
            buffer = buffer + this.mediumName;
        }
        if (this.shortName != null && this.shortName.length() > 0) {
            if (buffer.length() > 0) {
                buffer = buffer + "/";
            }
            buffer = buffer + this.shortName;
        }
        buffer = buffer + ")";
        return buffer;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getMediumName() {
        return this.mediumName;
    }

    public String[] getNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.longName != null && this.longName.length() > 0 && !list.contains(this.longName)) {
            list.add(this.longName);
        }
        if (this.mediumName != null && this.mediumName.length() > 0 && !list.contains(this.mediumName)) {
            list.add(this.mediumName);
        }
        if (this.shortName != null && this.shortName.length() > 0 && !list.contains(this.shortName)) {
            list.add(this.shortName);
        }
        if (this.propertyName != null && this.propertyName.length() > 0 && !list.contains(this.propertyName)) {
            list.add(this.propertyName);
        }
        String[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            names[i] = (String)list.get(i);
        }
        return names;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getUniqueName() {
        if (this.longName != null && this.longName.length() > 0) {
            return "--" + this.longName;
        }
        if (this.mediumName != null && this.mediumName.length() > 0) {
            return "-" + this.mediumName;
        }
        if (this.shortName != null && this.shortName.length() > 0) {
            return "-" + this.shortName;
        }
        if (this.propertyName != null && this.propertyName.length() > 0) {
            return this.propertyName;
        }
        return "???";
    }

    public T getValue() {
        T value = null;
        if (this.values.size() > 0) {
            value = this.values.get(0);
        }
        return value;
    }

    public ArrayList<T> getValues() {
        return this.values;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.longName.hashCode();
        result = 37 * result + this.mediumName.hashCode();
        result = 37 * result + this.shortName.hashCode();
        result = 37 * result + this.propertyName.hashCode();
        return result;
    }

    public boolean isLowerCase() {
        return this.isLowerCase;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public Option<T> isRequired(boolean value) {
        this.isRequired = value;
        return this;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public Option<T> isUnique(boolean value) {
        this.isUnique = value;
        return this;
    }

    public boolean isUnset() {
        return this.isUnset;
    }

    public void isUnset(boolean isUnset) {
        this.isUnset = isUnset;
    }

    public boolean isValid() {
        if (this.longName == null) {
            return false;
        }
        if (this.mediumName == null) {
            return false;
        }
        if (this.shortName == null) {
            return false;
        }
        if (this.propertyName == null) {
            return false;
        }
        return this.longName.length() != 0 || this.mediumName.length() != 0 || this.shortName.length() != 0 || this.propertyName.length() != 0;
    }

    public Option<T> setDefault(T value) {
        if (value == null) {
            throw new IllegalArgumentException(" The argument value may not be null!");
        }
        this.values.clear();
        this.values.add(value);
        return this;
    }

    public Option<T> setLongName(String longName) {
        if (longName == null) {
            throw new IllegalArgumentException(" The argument longName may not be null!");
        }
        this.longName = longName;
        return this;
    }

    public void setLowerCase(boolean isLowerCase) {
        this.isLowerCase = isLowerCase;
    }

    public Option<T> setMediumName(String mediumName) {
        if (mediumName == null) {
            throw new IllegalArgumentException(" The argument mediumName may not be null!");
        }
        this.mediumName = mediumName;
        return this;
    }

    public Option<T> setPropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(" The argument propertyName may not be null!");
        }
        this.propertyName = propertyName;
        return this;
    }

    public Option<T> setShortName(String shortName) {
        if (shortName == null) {
            throw new IllegalArgumentException(" The argument shortName may not be null!");
        }
        this.shortName = shortName;
        return this;
    }

    public abstract void setValueFromString(String var1);

    public void setValue(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Variable value is null!");
        }
        this.values.clear();
        this.values.add(value);
        this.isUnset = false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.propertyName != null && this.propertyName.length() > 0) {
            buffer.append(this.propertyName + " ");
        }
        if (this.longName != null && this.longName.length() > 0) {
            buffer.append(this.longName + " ");
        }
        if (this.mediumName != null && this.mediumName.length() > 0) {
            buffer.append(this.mediumName + " ");
        }
        if (this.shortName != null && this.shortName.length() > 0) {
            buffer.append(this.shortName + " ");
        }
        buffer.append("[");
        if (this.hasArgument) {
            buffer.append('A');
        } else {
            buffer.append('a');
        }
        if (this.isPresent) {
            buffer.append('P');
        } else {
            buffer.append('p');
        }
        if (this.isRequired) {
            buffer.append('R');
        } else {
            buffer.append('r');
        }
        buffer.append(']');
        for (int j = buffer.length(); j < 32; ++j) {
            buffer.append('.');
        }
        buffer.append(": ");
        List csList = this.values.stream().map(Object::toString).collect(Collectors.toList());
        buffer.append(String.join((CharSequence)",  ", csList));
        return buffer.toString();
    }

    protected boolean checkArgument(String arg) {
        return true;
    }

    protected String expandPath(String arg) {
        if (arg.startsWith("~")) {
            arg = FileServices.appendPath(System.getProperty("user.home"), arg.substring(1));
        }
        return arg;
    }

    protected boolean hasArgument() {
        return this.hasArgument;
    }

    protected void hasArgument(boolean value) {
        this.hasArgument = value;
    }

    protected void isPresent(boolean value) {
        this.isPresent = value;
    }

    public abstract OptionType getType();
}

