/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.option;

import java.io.File;
import org.dbdoclet.option.Option;
import org.dbdoclet.option.OptionType;

public class FileOption
extends Option<File> {
    private boolean isExisting = false;

    public FileOption() {
        this.hasArgument(true);
    }

    public FileOption(String longName) {
        super(longName);
        this.hasArgument(true);
    }

    public FileOption(String longName, String shortName) {
        super(longName, shortName);
        this.hasArgument(true);
    }

    @Override
    public void addValueFromString(String value) {
        this.addValue(new File(this.expandPath(value)));
    }

    public void isExisting(boolean value) {
        this.isExisting = value;
    }

    @Override
    public void setValueFromString(String value) {
        this.setValue(new File(this.expandPath(value)));
    }

    @Override
    protected boolean checkArgument(String arg) {
        arg = this.expandPath(arg);
        File file = new File(arg);
        if (this.isExisting && !file.exists()) {
            return false;
        }
        return !file.exists() || file.isFile();
    }

    @Override
    public OptionType getType() {
        return OptionType.FILE;
    }
}

