/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.option;

import java.io.File;
import org.dbdoclet.option.Option;
import org.dbdoclet.option.OptionType;

public class DirectoryOption
extends Option<File> {
    private boolean isExisting = false;
    private boolean createPath = false;

    public DirectoryOption() {
        this.hasArgument(true);
    }

    public DirectoryOption(String longName) {
        super(longName);
        this.hasArgument(true);
    }

    public DirectoryOption(String longName, String shortName) {
        super(longName, shortName);
        this.hasArgument(true);
    }

    public void isExisting(boolean value) {
        this.isExisting = value;
    }

    public void setCreatePath(boolean createPath) {
        this.createPath = createPath;
    }

    @Override
    protected boolean checkArgument(String arg) {
        File file = new File(arg = this.expandPath(arg));
        if (!file.exists() && this.createPath) {
            file.mkdirs();
        }
        if (this.isExisting && !file.exists()) {
            return false;
        }
        return !file.exists() || file.isDirectory();
    }

    @Override
    public void addValueFromString(String value) {
        this.addValue(new File(this.expandPath(value)));
    }

    @Override
    public void setValueFromString(String value) {
        this.setValue(new File(this.expandPath(value)));
    }

    @Override
    public OptionType getType() {
        return OptionType.FILE;
    }
}

