/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.manager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;

public class RecentManager
implements Serializable {
    private static final String home = System.getProperty("user.home");
    private static Log logger = LogFactory.getLog((String)RecentManager.class.getName());
    private static final long serialVersionUID = 3L;
    private String fileName = "recent.bin";
    private String id = ".recent";
    private int maxListSize = 10;
    private ArrayList<String> recentList = new ArrayList();

    public RecentManager(String id) {
        this(id, "recent.bin", 10);
    }

    public RecentManager(String id, String fileName) {
        this(id, fileName, 10);
    }

    public RecentManager(String id, String fileName, int size) {
        this.id = id;
        this.fileName = fileName;
        this.maxListSize = size;
        this.load(id, fileName, this.maxListSize);
    }

    public void add(File file) throws IOException {
        this.add(file.getCanonicalPath());
    }

    private void add(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name may not be null!");
        }
        if (this.recentList == null) {
            throw new IllegalStateException("The field recent may not be null!");
        }
        while (this.recentList.size() > this.maxListSize) {
            this.recentList.remove(this.recentList.size() - 1);
        }
        if (this.recentList.contains(name)) {
            logger.debug((Object)("Removing " + name));
            this.recentList.remove(name);
        }
        logger.debug((Object)("Adding " + name));
        this.recentList.add(0, name);
    }

    public ArrayList<String> getList() {
        return this.recentList;
    }

    private File getRecentFile(String id, String fileName) throws IOException {
        File file;
        if (id == null || fileName == null) {
            return null;
        }
        String fname = "";
        if (home != null && home.length() > 0) {
            fname = FileServices.appendPath(home, id);
            FileServices.createPath(fname);
            fname = FileServices.appendPath(fname, fileName);
        }
        if ((file = new File(fname)).exists() && file.canRead() && file.canWrite()) {
            return file;
        }
        return null;
    }

    private void load(String id, String fileName, int size) {
        if (id == null) {
            throw new IllegalArgumentException("The argument id may not be null!");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName may not be null!");
        }
        if (size < 10 || size > 32) {
            size = 10;
        }
        this.recentList = new ArrayList();
        try {
            File file = this.getRecentFile(id, fileName);
            if (file != null) {
                this.readFile(file);
            }
        }
        catch (Exception oops) {
            oops.printStackTrace();
            StringWriter buffer = new StringWriter();
            oops.printStackTrace(new PrintWriter(buffer));
            logger.fatal((Object)buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(File file) {
        if (file.exists() && file.canRead()) {
            if (this.recentList == null) {
                this.recentList = new ArrayList();
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                while (line != null) {
                    File recentFile = new File(line);
                    if (recentFile.exists() && recentFile.canRead()) {
                        this.recentList.add(line);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException oops) {
                logger.fatal((Object)"RecentManager.readFile failed!", (Throwable)oops);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException oops) {
                    logger.fatal((Object)"RecentManager.readFile failed!", (Throwable)oops);
                }
            }
        }
    }

    public boolean remove(String name) {
        if (name == null || this.recentList == null) {
            return false;
        }
        if (this.recentList.contains(name)) {
            this.recentList.remove(name);
            return true;
        }
        return false;
    }

    public void save() throws IOException {
        File file = this.getRecentFile(this.id, this.fileName);
        if (file != null) {
            this.writeFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file) {
        if (file == null || this.recentList == null) {
            return;
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            for (String line : this.recentList) {
                if (line == null) continue;
                writer.println(line);
            }
        }
        catch (IOException oops) {
            logger.fatal((Object)"RecentManager.readFile failed!", (Throwable)oops);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception oops) {
                logger.fatal((Object)"RecentManager.writeFile failed!", (Throwable)oops);
            }
        }
    }
}

