/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.manager;

import java.util.Collection;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.dbdoclet.progress.MessageListener;

public class MessageManager {
    private static MessageManager singleton = null;
    private static TreeMap<String, MessageListener> listeners = new TreeMap();
    public static final int FATAL = 1;
    public static final int ERROR = 2;
    public static final int WARN = 3;
    public static final int INFO = 4;
    public static final int DEBUG = 5;
    private int level = 4;
    private ResourceBundle res;

    public static MessageManager getInstance() {
        if (singleton == null) {
            singleton = new MessageManager();
        }
        return singleton;
    }

    private MessageManager() {
    }

    public void setResourceBundle(ResourceBundle res) {
        this.res = res;
    }

    public ResourceBundle getResourceBundle() {
        return this.res;
    }

    public static void addMessageListener(String name, MessageListener listener) {
        if (listeners == null) {
            throw new IllegalStateException("The field listeners may not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("The argument name may not be null!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("The argument listener may not be null!");
        }
        listeners.put(name, listener);
    }

    public static MessageListener getMessageListener(String name) {
        if (listeners == null) {
            throw new IllegalStateException("The field listeners may not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("The argument name may not be null!");
        }
        return listeners.get(name);
    }

    public void setLevel(int level) {
        if (level >= 1 && level <= 5) {
            this.level = level;
        }
    }

    public void debug(String msg) {
        if (listeners == null) {
            throw new IllegalStateException("The field listeners may not be null!");
        }
        if (msg == null) {
            throw new IllegalArgumentException("The argument msg may not be null!");
        }
        if (this.level < 5) {
            return;
        }
        Collection<MessageListener> list = listeners.values();
        for (MessageListener listener : list) {
            listener.debug(msg);
        }
    }

    public void info(String msg) {
        if (listeners == null) {
            throw new IllegalStateException("The field listeners may not be null!");
        }
        if (msg == null) {
            throw new IllegalArgumentException("The argument msg may not be null!");
        }
        Collection<MessageListener> list = listeners.values();
        for (MessageListener listener : list) {
            listener.info(msg);
        }
    }

    public void warn(String msg) {
        if (listeners == null) {
            throw new IllegalStateException("The field listeners may not be null!");
        }
        if (msg == null) {
            throw new IllegalArgumentException("The argument msg may not be null!");
        }
        Collection<MessageListener> list = listeners.values();
        for (MessageListener listener : list) {
            listener.info(msg);
        }
    }

    public void error(String msg) {
        if (listeners == null) {
            throw new IllegalStateException("The field listeners may not be null!");
        }
        if (msg == null) {
            throw new IllegalArgumentException("The argument msg may not be null!");
        }
        Collection<MessageListener> list = listeners.values();
        for (MessageListener listener : list) {
            listener.error(msg);
        }
    }

    public void fatal(String msg, Throwable oops) {
        if (listeners == null) {
            throw new IllegalStateException("The field listeners may not be null!");
        }
        if (msg == null) {
            throw new IllegalArgumentException("The argument msg may not be null!");
        }
        if (oops == null) {
            throw new IllegalArgumentException("The argument oops may not be null!");
        }
        Collection<MessageListener> list = listeners.values();
        for (MessageListener listener : list) {
            listener.fatal(msg, oops);
        }
    }

    public static int valueOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        if (name.equalsIgnoreCase("fatal")) {
            return 1;
        }
        if (name.equalsIgnoreCase("error")) {
            return 2;
        }
        if (name.equalsIgnoreCase("warn")) {
            return 3;
        }
        if (name.equalsIgnoreCase("info")) {
            return 4;
        }
        if (name.equalsIgnoreCase("debug")) {
            return 5;
        }
        System.err.println("[WARNING] Unknown logging level '" + name + "'. Using INFO.");
        return 4;
    }

    public static String levelToString(int level) {
        String label = "";
        switch (level) {
            case 1: {
                label = "FATAL ";
                break;
            }
            case 2: {
                label = "ERROR ";
                break;
            }
            case 3: {
                label = "WARN  ";
                break;
            }
            case 4: {
                label = "INFO  ";
                break;
            }
            case 5: {
                label = "DEBUG ";
                break;
            }
            default: {
                label = String.valueOf(level);
            }
        }
        return label;
    }
}

