/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.manager;

import java.util.HashMap;
import org.dbdoclet.DuplicateHashCodeException;

public class HashcodeManager {
    private static HashcodeManager singleton = null;
    private HashMap<Long, String> hcMap = new HashMap();
    private HashMap<String, Long> moduleMap = new HashMap();

    private HashcodeManager() {
    }

    public static HashcodeManager getInstance() {
        if (singleton == null) {
            singleton = new HashcodeManager();
        }
        return singleton;
    }

    public long createHashcode(String value) throws DuplicateHashCodeException {
        if (value == null) {
            return 0L;
        }
        long hc = 0L;
        for (int i = 0; i < value.length(); ++i) {
            hc = (hc * 128L + (long)value.charAt(i)) % 999999937L;
        }
        String str = this.hcMap.get(new Long(hc));
        if (str != null && !value.equals(str)) {
            throw new DuplicateHashCodeException("Duplicate Hash Entry " + hc + " for entries " + value + " and " + str + "!");
        }
        this.hcMap.put(new Long(hc), value);
        this.moduleMap.put(value, new Long(hc));
        return hc;
    }

    public long getHashcode(String value) {
        if (value == null) {
            return -1L;
        }
        Long hc = this.moduleMap.get(value);
        if (hc == null) {
            return -1L;
        }
        return hc;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("hc <VALUE> <VALUE> ...");
            return;
        }
        HashcodeManager hc = HashcodeManager.getInstance();
        for (String value : args) {
            try {
                System.out.println(hc.createHashcode(value));
            }
            catch (DuplicateHashCodeException e) {
                e.printStackTrace();
            }
        }
    }
}

