/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.dbdoclet.io.Screen;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;

@Deprecated
public class Logger {
    private static final String LSEP = System.getProperty("line.separator");
    private static Map<String, Logger> loggerMap = Collections.synchronizedMap(new TreeMap());
    private static Properties config = new Properties();
    public static final int FATAL = 1;
    public static final int ERROR = 2;
    public static final int WARN = 3;
    public static final int INFO = 4;
    public static final int DEBUG = 5;
    public static final int DEBUG2 = 6;
    public static final int DEBUG3 = 7;
    public static final int DEBUG4 = 8;
    public static final int DEBUG5 = 9;
    public static final int SHORT = 1;
    public static final int MEDIUM = 2;
    public static final int LONG = 3;
    private static boolean trace = false;
    private static PrintWriter rootWriter = null;
    private static Screen rootScreen;
    private static SimpleDateFormat datefmt;
    private static boolean isMethodNameVisible;
    private static int rootLogLevel;
    private static int rootOutputFormat;
    private static boolean outputEnabled;
    private static boolean lineWrapEnabled;
    private final String name;
    private HashMap<String, String> methodMap;
    private int outputFormat = 2;
    private final PrintWriter writer;
    private int logLevel = 2;

    private Logger(Class<?> clazz) {
        this(clazz.getName(), clazz, null);
    }

    private Logger(String name) {
        this(name, null, null);
    }

    private Logger(String name, Class<?> clazz, PrintWriter writer) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        this.name = name;
        this.writer = writer;
        String level = config.getProperty(name + ".level");
        if (level != null) {
            Logger.applyLevelInfo(this, level);
        }
    }

    private Logger(String name, PrintWriter writer) {
        this(name, null, writer);
    }

    public static String createLine(int level, int outputFormat, String name, HashMap<String, String> methodMap, Object msg) {
        String line = (rootOutputFormat == 1 || outputFormat == 1) && level == 4 ? "" : "[" + Logger.levelToString(level) + " " + datefmt.format(new Date()) + "] ";
        if (isMethodNameVisible && level == 5) {
            Throwable throwable = new Throwable();
            StringWriter buffer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(buffer));
            BufferedReader reader = new BufferedReader(new StringReader(buffer.toString()));
            try {
                String token = reader.readLine();
                token = reader.readLine();
                while (token != null && token.indexOf("org.dbdoclet.log.Logger") != -1) {
                    token = reader.readLine();
                }
                if (token != null) {
                    token = token.trim();
                    token = StringServices.cutPrefix(token, "at ");
                    token = StringServices.cutSuffix(token, "(Unknown Source)");
                    String method = StringServices.cutPrefix(token, name);
                    int index = (method = StringServices.cutPrefix(method, ".")).indexOf(40);
                    if (index > 0) {
                        method = method.substring(0, method.indexOf(40));
                    }
                    if (methodMap != null && methodMap.get(method) == null) {
                        return null;
                    }
                    line = line + " <at " + token + "> ";
                }
            }
            catch (IOException iOException) {}
        } else if ((rootOutputFormat != 1 && outputFormat != 1 || level == 5) && name != null && name.length() > 0) {
            line = line + " (" + name + ") ";
        }
        line = lineWrapEnabled ? line + LSEP + msg : line + " " + msg;
        return line;
    }

    public static boolean exists(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        Logger logger = loggerMap.get(name);
        return logger != null;
    }

    public static Logger getLogger(Class<? extends Object> clazz, int level) {
        Logger logger = Logger.getLogger(clazz);
        logger.setLogLevel(level);
        return logger;
    }

    public static Logger getLogger(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The argument clazz may not be null!");
        }
        String name = clazz.getName();
        Logger logger = loggerMap.get(name);
        if (logger == null) {
            logger = new Logger(clazz);
            loggerMap.put(logger.getName(), logger);
        }
        return logger;
    }

    public static Logger getLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        Logger logger = loggerMap.get(name);
        if (logger == null) {
            logger = new Logger(name);
            loggerMap.put(logger.getName(), logger);
        }
        return logger;
    }

    public static Logger getLogger(String name, int level) {
        Logger logger = Logger.getLogger(name);
        logger.setLogLevel(level);
        return logger;
    }

    public static String levelToString(int level) {
        String label = "";
        switch (level) {
            case 1: {
                label = "FATAL ";
                break;
            }
            case 2: {
                label = "ERROR ";
                break;
            }
            case 3: {
                label = "WARN  ";
                break;
            }
            case 4: {
                label = "INFO  ";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                label = "DEBUG ";
                break;
            }
            default: {
                label = String.valueOf(level);
            }
        }
        return label;
    }

    @Deprecated
    public static void log(int level, int outputFormat, int logLevel, Object msg) {
        Logger logger = new Logger("");
        logger.setLogLevel(logLevel);
        logger.setOutputFormat(outputFormat);
        Logger.log(level, logger, msg);
    }

    public static void log(int level, int logLevel, Object msg, Throwable oops) {
        Logger logger = new Logger("");
        logger.setLogLevel(logLevel);
        Logger.log(level, logger, msg, oops);
    }

    public static void log(int level, Logger logger, Object msg) {
        String line;
        if (msg == null) {
            throw new IllegalArgumentException("The argument msg may not be null!");
        }
        int logLevel = logger.getLogLevel();
        String name = logger.getName();
        PrintWriter writer = logger.getWriter();
        if ((level <= rootLogLevel || level <= logLevel) && (line = Logger.createLine(level, logger.getOutputFormat(), name, logger.getMethodMap(), msg)) != null) {
            Logger.printLine(writer, level, line);
        }
    }

    public static void log(int level, Logger logger, Object msg, Throwable oops) {
        String line;
        if (msg == null) {
            throw new IllegalArgumentException("The argument msg may not be null!");
        }
        if (oops == null) {
            throw new IllegalArgumentException("The argument oops may not be null!");
        }
        HashMap<String, String> methodMap = logger.getMethodMap();
        PrintWriter writer = logger.getWriter();
        String name = logger.getName();
        int logLevel = logger.getLogLevel();
        if ((level <= rootLogLevel || level <= logLevel) && (line = Logger.createLine(level, logger.getOutputFormat(), name, methodMap, msg)) != null) {
            Logger.printLine(writer, level, line);
            StringWriter buffer = new StringWriter();
            oops.printStackTrace(new PrintWriter(buffer));
            Logger.printLine(writer, level, buffer.toString());
        }
    }

    public static void log(int level, Object msg) {
        Logger logger = new Logger("");
        logger.setLogLevel(rootLogLevel);
        Logger.log(level, logger, msg);
    }

    public static void log(int level, Object msg, Throwable oops) {
        Logger logger = new Logger("");
        logger.setLogLevel(rootLogLevel);
        Logger.log(level, logger, msg, oops);
    }

    public static void log(Object msg) {
        Logger logger = new Logger("");
        logger.setLogLevel(rootLogLevel);
        Logger.log(4, logger, msg);
    }

    public static Logger newLogger(String name, PrintWriter writer) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name may not be null!");
        }
        if (writer == null) {
            throw new IllegalArgumentException("The argument writer may not be null!");
        }
        Logger logger = new Logger(name, writer);
        loggerMap.put(logger.getName(), logger);
        return logger;
    }

    public static void printLine(PrintWriter writer, int logLevel, String line) {
        if (writer != null) {
            if (outputEnabled) {
                writer.println(line);
                writer.flush();
            }
        } else if (rootWriter != null) {
            if (outputEnabled) {
                rootWriter.println(line);
                rootWriter.flush();
            }
        } else {
            Logger.println(line);
        }
        if (rootScreen != null && outputEnabled) {
            if (logLevel == 5 || logLevel == 4) {
                rootScreen.info(line);
            }
            if (logLevel == 3) {
                rootScreen.warning(line);
            }
            if (logLevel == 2) {
                rootScreen.error(line);
            }
            if (logLevel == 1) {
                rootScreen.error(line);
            }
        }
    }

    public static void println(Object msg) {
        if (msg == null) {
            throw new IllegalArgumentException("The argument msg may not be null!");
        }
        if (outputEnabled) {
            System.out.println(msg.toString());
        }
    }

    public static void printStackTrace() {
        Throwable throwable = new Throwable();
        StringWriter buffer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(buffer));
        if (rootWriter != null) {
            if (outputEnabled) {
                rootWriter.println(buffer);
            }
        } else {
            Logger.println(buffer);
        }
        if (rootScreen != null && outputEnabled) {
            rootScreen.error(buffer.toString());
        }
    }

    public static void readConfiguration(File configFile) throws FileNotFoundException {
        if (configFile != null && configFile.exists()) {
            Logger.readConfiguration(new FileInputStream(configFile));
        }
    }

    public static void readConfiguration(InputStream instr) {
        if (instr == null) {
            return;
        }
        try {
            if (config == null) {
                config = new Properties();
            }
            config.load(instr);
            Enumeration<?> e = config.propertyNames();
            while (e.hasMoreElements()) {
                String value;
                String property = (String)e.nextElement();
                if (property.endsWith(".level")) {
                    String name = StringServices.chop(property, ".level");
                    value = config.getProperty(property);
                    Logger logger = loggerMap.get(name);
                    if (logger != null) {
                        Logger.applyLevelInfo(logger, value);
                    }
                }
                if (property.equals("visibility.method")) {
                    value = config.getProperty(property);
                    isMethodNameVisible = new Boolean(value);
                }
                if (property.equals("output.enabled")) {
                    value = config.getProperty(property);
                    outputEnabled = new Boolean(value);
                }
                if (property.equals("logger.rootLogLevel")) {
                    value = config.getProperty(property);
                    Logger.setRootLogLevel(Logger.valueOf(value));
                }
                if (!property.equals("logger.file")) continue;
                value = config.getProperty(property);
                value = StringServices.replace(value, "${catalina.base}", System.getProperty("catalina.base", "/tmp"));
                Logger.setRootWriter(new PrintWriter(new FileWriter(value)));
            }
        }
        catch (IOException oops) {
            oops.printStackTrace();
        }
    }

    public static void setLineWrapEnabled(boolean lineWrapEnabled) {
        Logger.lineWrapEnabled = lineWrapEnabled;
    }

    public static void setRootLogLevel(int level) {
        rootLogLevel = level;
    }

    public static void setLoggerLevel(Class<?> clazz, int level) {
        if (clazz == null) {
            return;
        }
        Logger logger = loggerMap.get(clazz.getName());
        if (logger != null) {
            logger.setLogLevel(level);
        } else {
            config.setProperty(clazz.getName() + ".level", Logger.levelAsText(level));
        }
    }

    private static String levelAsText(int level) {
        switch (level) {
            case 9: {
                return "debug5";
            }
            case 8: {
                return "debug4";
            }
            case 7: {
                return "debug3";
            }
            case 6: {
                return "debug2";
            }
            case 5: {
                return "debug";
            }
            case 4: {
                return "info";
            }
            case 3: {
                return "warn";
            }
            case 2: {
                return "error";
            }
            case 1: {
                return "fatal";
            }
        }
        return "error";
    }

    public static void setRootOutputFormat(int rootOutputFormat) {
        if (rootOutputFormat >= 1 && rootOutputFormat <= 3) {
            Logger.rootOutputFormat = rootOutputFormat;
        }
    }

    public static void setRootScreen(Screen screen) {
        rootScreen = screen;
    }

    public static void setRootWriter(PrintWriter writer) {
        rootWriter = writer;
    }

    public static int valueOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        if (name.equalsIgnoreCase("fatal")) {
            return 1;
        }
        if (name.equalsIgnoreCase("error")) {
            return 2;
        }
        if (name.equalsIgnoreCase("warn")) {
            return 3;
        }
        if (name.equalsIgnoreCase("info")) {
            return 4;
        }
        if (name.equalsIgnoreCase("debug")) {
            return 5;
        }
        if (name.equalsIgnoreCase("debug2")) {
            return 6;
        }
        if (name.equalsIgnoreCase("debug3")) {
            return 7;
        }
        if (name.equalsIgnoreCase("debug4")) {
            return 8;
        }
        if (name.equalsIgnoreCase("debug5")) {
            return 9;
        }
        System.err.println("[WARNING] Unknown logging level '" + name + "'. Using INFO.");
        return 4;
    }

    private static void applyLevelInfo(Logger logger, String info) {
        if (logger == null) {
            throw new IllegalArgumentException("The argument logger must not be null!");
        }
        if (info == null) {
            throw new IllegalArgumentException("The argument info must not be null!");
        }
        int index = info.indexOf(40);
        if (index != -1) {
            int indexParamsStart = index + 1;
            int indexParamsEnd = info.length() - 1;
            String params = "";
            if (indexParamsStart > 0 && indexParamsEnd > 0 && indexParamsStart < indexParamsEnd) {
                params = info.substring(indexParamsStart, indexParamsEnd);
                logger.addLogMethod(params);
            }
            info = info.substring(0, index);
        }
        logger.setLogLevel(Logger.valueOf(info));
    }

    private static void ptrace(String msg) {
        if (trace) {
            System.out.println(msg);
        }
    }

    public void addLogMethod(String param) {
        if (this.methodMap == null) {
            this.methodMap = new HashMap();
        }
        this.methodMap.put(param, param);
    }

    public void debug5(Object msg) {
        Logger.log(9, this, msg);
    }

    public void debug4(Object msg) {
        Logger.log(8, this, msg);
    }

    public void debug3(Object msg) {
        Logger.log(7, this, msg);
    }

    public void debug2(Object msg) {
        Logger.log(6, this, msg);
    }

    public void debug(Object msg) {
        Logger.log(5, this, msg);
    }

    public void error(Object msg) {
        Logger.log(2, this, msg);
    }

    public void error(Object msg, Throwable oops) {
        Logger.log(2, this, msg, oops);
    }

    public void fatal(Object msg) {
        Logger.log(1, this, msg);
    }

    public void fatal(Object msg, Throwable oops) {
        Logger.log(1, this, msg, oops);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public HashMap<String, String> getMethodMap() {
        return this.methodMap;
    }

    public String getName() {
        return this.name;
    }

    public int getOutputFormat() {
        return this.outputFormat;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void info(Object msg) {
        Logger.log(4, this, msg);
    }

    public void printList(int level, List<Object> list) {
        String msg = "";
        if (list != null) {
            for (Object value : list) {
                if (value == null) {
                    msg = msg + "null" + LSEP;
                    continue;
                }
                msg = msg + value + " [" + value.getClass().getName() + "]" + LSEP;
            }
        }
        Logger.log(level, this, msg);
    }

    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    public void setOutputFormat(int outputFormat) {
        if (outputFormat >= 1 && outputFormat <= 3) {
            this.outputFormat = outputFormat;
        }
    }

    public void setVar(String name, Object var) {
        if (name == null) {
            name = "???name???";
        }
        if (var == null) {
            var = "[:null:]";
        }
        this.debug("Der Variablen " + name + " wurde der Wert '" + var + "' zugewiesen.");
    }

    public void warn(Object msg) {
        Logger.log(3, this, msg);
    }

    public void warn(Object msg, Throwable oops) {
        Logger.log(3, this, msg, oops);
    }

    static {
        datefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        isMethodNameVisible = false;
        rootLogLevel = 2;
        rootOutputFormat = 2;
        outputEnabled = true;
        lineWrapEnabled = true;
        try {
            InputStream instr;
            String value = System.getProperty("logger.debug");
            if (value != null && value.equalsIgnoreCase("true")) {
                trace = true;
                Logger.ptrace("Debugging Logger enabled.");
            }
            if ((instr = ResourceServices.getResourceAsStream("Logger.properties")) != null) {
                Logger.ptrace(String.format("Loading configuration %s...", ResourceServices.getResourceAsUrl("Logger.properties")));
                Logger.readConfiguration(instr);
            } else {
                Logger.ptrace("File Logger.properties not found.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

