/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.lock;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileLock {
    private static Log logger = LogFactory.getLog(FileLock.class);
    private File file;
    private String data;

    public FileLock(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        this.file = file;
    }

    public FileLock(String fileName) {
        this(new File(fileName));
    }

    public synchronized boolean lock(String data) {
        if (this.file == null) {
            throw new IllegalStateException("The field file must not be null!");
        }
        if (this.file.exists()) {
            return false;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(this.file));
            writer.println(data);
            writer.close();
            this.data = data;
        }
        catch (IOException oops) {
            logger.fatal((Object)"FileLock.lock", (Throwable)oops);
            oops.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized boolean unlock() {
        if (this.file == null) {
            throw new IllegalStateException("The field file must not be null!");
        }
        if (!this.file.exists()) {
            return true;
        }
        return this.file.delete();
    }

    public String getData() {
        return this.data;
    }
}

