/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget.sidebar;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.dbdoclet.jive.widget.sidebar.SideBarButton;

public class SideBarGroup
implements Comparable<SideBarGroup> {
    public static final SideBarGroup DEFAULT_GROUP = new SideBarGroup("default");
    private String name;
    private ArrayList<SideBarButton> buttonList;
    private int tabIndex;

    public SideBarGroup(String name) {
        this(name, 0);
    }

    public SideBarGroup(String name, int tabIndex) {
        this.name = name;
        this.tabIndex = tabIndex;
        this.buttonList = new ArrayList();
    }

    public void addButton(SideBarButton button) {
        button.setGroup(this);
        this.buttonList.add(button);
    }

    @Override
    public int compareTo(SideBarGroup o) {
        if (this.tabIndex != o.getTabIndex()) {
            return new Integer(this.tabIndex).compareTo(new Integer(o.getTabIndex()));
        }
        if (this.name == null || o.getName() == null) {
            return 0;
        }
        return this.name.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SideBarGroup)) {
            return false;
        }
        SideBarGroup otherGroup = (SideBarGroup)obj;
        String otherName = otherGroup.getName();
        return this.name.equals(otherName);
    }

    public ArrayList<SideBarButton> getButtonList() {
        return this.buttonList;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "default";
        }
        return this.name;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public int hashCode() {
        if (this.name == null) {
            return 0;
        }
        return this.name.hashCode();
    }

    public void setIcon(ImageIcon icon) {
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }
}

