/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget.sidebar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.dbdoclet.jive.widget.SideBar;
import org.dbdoclet.jive.widget.sidebar.SideBarGroup;

public class SideBarButton
extends JButton
implements MouseListener,
Comparable<SideBarButton> {
    private static final long serialVersionUID = 1L;
    public static final Border INACTIVE_BORDER = new EmptyBorder(3, 3, 3, 3);
    public static final Border ACTIVE_BORDER = new EmptyBorder(3, 3, 3, 3);
    private static final int MAX_TAB_INDEX = 64;
    private SideBar sideBar;
    private boolean active;
    private Font font;
    private Font activeFont;
    private SideBarGroup group;
    private int tabIndex = 64;

    public SideBarButton(AbstractAction action) {
        this(action, 64);
    }

    public SideBarButton(AbstractAction action, int tabIndex) {
        super(action);
        this.tabIndex = tabIndex;
        Rectangle rect = new Rectangle(150, 90);
        this.setBorder(INACTIVE_BORDER);
        this.setMinimumSize(new Dimension(150, 90));
        this.setPreferredSize(new Dimension(150, 90));
        this.setMaximumSize(new Dimension(150, 90));
        this.setSize(150, 90);
        this.setBounds(rect);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(false);
        this.setBorderPainted(true);
        this.setFocusPainted(false);
        this.setOpaque(true);
        this.addMouseListener(this);
        this.active = false;
        this.font = this.getFont();
        this.font = this.font.deriveFont(0);
        this.activeFont = this.font.deriveFont(1);
        this.setFont(this.font);
    }

    @Override
    public int compareTo(SideBarButton o) {
        if (o == null) {
            return 1;
        }
        if (this.getTabIndex() != o.getTabIndex()) {
            return this.getTabIndex().compareTo(o.getTabIndex());
        }
        String text = this.getText();
        if (text == null) {
            return -1;
        }
        return text.compareTo(o.getText());
    }

    public SideBarGroup getGroup() {
        if (this.group == null) {
            this.group = new SideBarGroup("default");
        }
        return this.group;
    }

    public SideBar getSideBar() {
        return this.sideBar;
    }

    public boolean isActive() {
        return this.active;
    }

    public void isActive(boolean active) {
        if (this.sideBar == null) {
            throw new IllegalStateException("The field sideBar must not be null!");
        }
        this.active = active;
        if (!active) {
            this.setBorder(INACTIVE_BORDER);
            this.setBackground(this.sideBar.getBackground());
            this.setForeground(Color.black);
            this.setFont(this.font);
        } else {
            this.setBorder(ACTIVE_BORDER);
            this.setBackground(new Color(199, 199, 199));
            this.setForeground(Color.black);
            this.setFont(this.activeFont);
        }
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
        this.setFont(this.activeFont);
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
        if (!this.isActive()) {
            this.setFont(this.font);
        }
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setGroup(SideBarGroup group) {
        this.group = group;
    }

    public void setSideBar(SideBar sideBar) {
        this.sideBar = sideBar;
        if (sideBar != null) {
            this.setBackground(sideBar.getBackground());
        }
    }

    private Integer getTabIndex() {
        return this.tabIndex;
    }
}

