/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget.pathlist;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.dbdoclet.io.FileSet;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.model.PathListModel;
import org.dbdoclet.service.ResourceServices;

public class StatusRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res;
    private PathListModel model;
    private ImageIcon errorIcon;

    public StatusRenderer(PathListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("The argument model may not be null!");
        }
        this.model = model;
        JiveFactory wm = JiveFactory.getInstance();
        res = wm.getResourceBundle();
        URL iconURL = ClassLoader.getSystemResource("images/status-error.png");
        if (iconURL != null) {
            this.errorIcon = new ImageIcon(iconURL, "Error");
        }
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (row > -1) {
            FileSet fileset = this.model.getEntry(row);
            value = this.getStatusLabel(fileset.getStatus());
            this.setIcon(null);
            if (fileset.getStatus() == 0) {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (fileset.getStatus() == 1) {
                if (this.errorIcon != null) {
                    this.setIcon(this.errorIcon);
                } else {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.RED);
                }
            }
            if (fileset.getStatus() == 4) {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.YELLOW);
            }
            this.setToolTipText(this.getStatusLabel(fileset.getStatus()));
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    private String getStatusLabel(int status) {
        switch (status) {
            case 0: {
                return ResourceServices.getString(res, "C_OK");
            }
            case 1: {
                return ResourceServices.getString(res, "C_NOT_FOUND");
            }
            case 2: {
                return ResourceServices.getString(res, "C_NOT_READABLE");
            }
            case 3: {
                return ResourceServices.getString(res, "C_DUPLICATE");
            }
            case 4: {
                return ResourceServices.getString(res, "C_VARIABLE");
            }
        }
        return ResourceServices.getString(res, "C_UNKNOWN_STATUS");
    }
}

