/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget.pathlist;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.dbdoclet.io.FileSet;
import org.dbdoclet.jive.model.PathListModel;

public class RecursiveRenderer
extends JCheckBox
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    PathListModel model;

    public RecursiveRenderer(PathListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("The argument model may not be null!");
        }
        this.model = model;
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean recursive = true;
        if (value != null && value instanceof Boolean) {
            recursive = (Boolean)value;
        }
        this.setSelected(recursive);
        if (row > -1) {
            FileSet fileset = this.model.getEntry(row);
            if (fileset.isDirectory()) {
                this.setEnabled(true);
            } else {
                this.setSelected(false);
                this.setEnabled(false);
            }
        }
        return this;
    }
}

