/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget.pathlist;

import java.awt.Component;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.dbdoclet.io.FileSet;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.model.PathListModel;
import org.dbdoclet.service.ResourceServices;

public class FilterTypeRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private PathListModel model;

    public FilterTypeRenderer(PathListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("The argument model may not be null!");
        }
        this.model = model;
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        FileSet fileset = null;
        JiveFactory jf = JiveFactory.getInstance();
        ResourceBundle res = jf.getResourceBundle();
        if (row > -1) {
            File path;
            fileset = this.model.getEntry(row);
            if (fileset.getFilterType() == 0) {
                value = new String("");
            }
            if (fileset != null && !fileset.isDirectory() && (path = fileset.getPath()) != null && path.isFile()) {
                value = ResourceServices.getString(res, "C_FILE");
            }
        }
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (fileset == null || !fileset.isDirectory()) {
            comp.setEnabled(false);
        } else {
            comp.setEnabled(true);
        }
        return comp;
    }
}

