/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget.imagemap;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.widget.imagemap.ImageMapException;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.xiphias.XmlServices;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImageMapDefinition {
    private static Log logger = LogFactory.getLog(ImageMapDefinition.class);
    private String imageMapContent;
    private HashMap<Rectangle, Action> areaMap;

    public ImageMapDefinition(String mapFileResource) throws ImageMapException {
        if (mapFileResource == null) {
            throw new IllegalArgumentException("Argument mapFileResource must not be null");
        }
        this.imageMapContent = "<mymap>";
        String line = "";
        try {
            InputStream io = ResourceServices.getResourceAsStream(mapFileResource);
            BufferedReader br = new BufferedReader(new InputStreamReader(io));
            while (line != null) {
                this.imageMapContent = this.imageMapContent + "\n" + line;
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new ImageMapException("Got IOException while trying to parse the resource " + mapFileResource, e);
        }
        this.imageMapContent = this.imageMapContent + "\n</mymap>";
        this.readAreas();
    }

    protected void readAreas() throws ImageMapException {
        if (this.areaMap == null) {
            this.areaMap = new HashMap();
        }
        File tmpFile = new File("./imgm");
        try {
            FileServices.writeFromString(tmpFile, this.imageMapContent);
        }
        catch (IOException e1) {
            throw new ImageMapException("could not write temporary file: " + tmpFile.getAbsolutePath(), e1);
        }
        try {
            Document doc;
            try {
                doc = XmlServices.parse(tmpFile);
            }
            catch (IOException e) {
                throw new ImageMapException("Could not read from " + tmpFile.getAbsolutePath() + " to parse XML-file", e);
            }
            NodeList nl = doc.getElementsByTagName("area");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node actnode = nl.item(i);
                NamedNodeMap atts = actnode.getAttributes();
                String alt = null;
                String coords = null;
                for (int j = 0; j < atts.getLength(); ++j) {
                    String nm = atts.item(j).getNodeName();
                    String val = atts.item(j).getNodeValue();
                    if (nm == null) continue;
                    if (nm.toLowerCase().equals("alt")) {
                        alt = val;
                        continue;
                    }
                    if (!nm.toLowerCase().equals("coords")) continue;
                    coords = val;
                }
                if (alt == null || coords == null) {
                    logger.error((Object)("Attribute alt and attribute coords has to be defined! - Change yourimagemap-file - ignoring map-area: " + alt + " with coords: " + coords));
                    continue;
                }
                Rectangle rect = null;
                try {
                    rect = this.getRectangle(coords);
                }
                catch (ImageMapException e) {
                    logger.fatal((Object)(e.getMessage() + alt));
                }
                Action action = this.getAction(alt);
                if (action == null || rect == null) continue;
                this.areaMap.put(rect, action);
            }
        }
        catch (SAXException e) {
            logger.fatal((Object)("Error while parsing imagemap: " + this.getContent()), (Throwable)e);
            throw new ImageMapException("Error while parsing imagemap:", e);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)("Error while parsing imagemap: " + this.getContent()), (Throwable)e);
            throw new ImageMapException("Error while parsing imagemap:", e);
        }
    }

    private Action getAction(String alt) {
        Class<?> actClass = null;
        Action retval = null;
        try {
            actClass = Class.forName(alt);
        }
        catch (ClassNotFoundException e) {
            logger.fatal((Object)("Could not find class: " + alt + " no such action supported"));
        }
        if (actClass != null) {
            try {
                retval = (Action)actClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.fatal((Object)("Could not instantiate " + alt + " - class is abstract, interface, aray-class, a primitive type or void" + " or no default constructor present"));
            }
            catch (IllegalAccessException e) {
                logger.fatal((Object)("could not access constructor of classobject for " + alt), (Throwable)e);
            }
            catch (ClassCastException e) {
                logger.fatal((Object)("could not generate action from " + alt + " - perhaps not an Action class?"), (Throwable)e);
            }
        }
        return retval;
    }

    private Rectangle getRectangle(String coords) throws ImageMapException {
        StringTokenizer tok = new StringTokenizer(coords, ",");
        if (tok.countTokens() != 4) {
            throw new ImageMapException("Wrong number of coordinates is defined for the area: - will ignore area");
        }
        String token = tok.nextToken();
        int x = Integer.parseInt(token);
        token = tok.nextToken();
        int y = Integer.parseInt(token);
        token = tok.nextToken();
        int x2 = Integer.parseInt(token);
        token = tok.nextToken();
        int y2 = Integer.parseInt(token);
        int width = x2 - x;
        int height = y2 - y;
        return new Rectangle(x, y, width, height);
    }

    public String getContent() {
        return this.imageMapContent;
    }

    public HashMap<Rectangle, Action> getAreaMap() {
        return this.areaMap;
    }
}

