/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget.fstree;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.dbdoclet.jive.widget.fstree.ChildEnumeration;

public class FileSystemTreeNode
implements TreeNode {
    private File[] children;
    private File file = new File("null");
    private FileSystemTreeNode parent;

    public FileSystemTreeNode(File file, FileSystemTreeNode parent) {
        this.file = file;
        this.parent = parent;
        this.children = file.listFiles();
        if (this.children == null) {
            this.children = new File[0];
        } else {
            Arrays.sort(this.children);
        }
    }

    public FileSystemTreeNode(File[] children) {
        if (children == null) {
            children = new File[]{};
        }
        this.children = children;
        Arrays.sort(children);
        this.parent = null;
        this.file = new File("");
    }

    public Enumeration<?> children() {
        return new ChildEnumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this.children == null) {
            return null;
        }
        if (childIndex < 0 || childIndex >= this.children.length) {
            return null;
        }
        return new FileSystemTreeNode(this.children[childIndex], this);
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.length;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int getIndex(TreeNode node) {
        FileSystemTreeNode child = (FileSystemTreeNode)node;
        for (int i = 0; i < this.children.length; ++i) {
            if (!child.file.equals(this.children[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.length == 0;
    }

    public String toString() {
        return "[Parent=" + this.parent + ",file=" + this.file + "]";
    }

    public TreePath getTreePath() {
        ArrayList<FileSystemTreeNode> nodeList = new ArrayList<FileSystemTreeNode>();
        for (FileSystemTreeNode node = this; node != null; node = (FileSystemTreeNode)node.getParent()) {
            nodeList.add(node);
        }
        Collections.reverse(nodeList);
        return new TreePath(nodeList.toArray());
    }
}

