/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.format.Alignment;
import org.dbdoclet.jive.filter.BlurFilter;

public class TopPanel
extends JPanel {
    private static final int BLUR_RADIUS = 9;
    private static Log logger = LogFactory.getLog(TopPanel.class);
    private static final long serialVersionUID = 1L;
    private static final int SHADOW_CANVAS_HEIGHT = 50;
    private static final int SHADOW_CANVAS_WIDTH = 4096;
    private static final int SHADOW_HEIGHT = 10;
    private Alignment alignment = Alignment.CENTER;
    private Color gradientColorFrom;
    private Color gradientColorTo;
    private int height = 60;
    private int width = 0;
    private BufferedImage leftImage;
    private BufferedImage rightImage;
    private Image shadowImage;
    private String title = "";
    private boolean titleHasChanged;
    private BufferedImage titleImage;
    private final Color eraseColor;

    public TopPanel() {
        this.setFont(new Font("Serif", 0, 24));
        this.eraseColor = this.getBackground();
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.width == 0) {
            this.width = this.computeWidth(this.getTitle());
        }
        if (dim.height < this.height) {
            dim.height = this.height;
        }
        if (dim.width < this.width) {
            dim.width = this.width;
        }
        return dim;
    }

    public String getTitle() {
        if (this.title == null) {
            return "Title";
        }
        return this.title;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.leftImage != null && this.leftImage.getHeight() > this.height) {
            this.height = this.leftImage.getHeight();
        }
        if (this.rightImage != null && this.rightImage.getHeight() > this.height) {
            this.height = this.rightImage.getHeight();
        }
        if (this.shadowImage == null) {
            this.createShadow();
        }
        if (this.titleImage == null || this.titleHasChanged) {
            this.createTitleImage(this.getTitle());
            this.titleHasChanged = false;
        }
        if (this.titleImage != null && this.titleImage.getHeight() > this.height) {
            this.height = this.titleImage.getHeight() + 10;
        }
        g2d.setPaint(this.eraseColor);
        g2d.fillRect(0, 0, this.getWidth(), this.height);
        if (this.gradientColorFrom != null && this.gradientColorTo != null) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.gradientColorFrom, this.getWidth(), this.height / 2, this.gradientColorTo, false));
        } else {
            g2d.setPaint(this.getBackground());
        }
        g2d.fillRect(0, 0, this.getWidth(), this.height - 10);
        if (this.leftImage != null) {
            g2d.drawImage((Image)this.leftImage, 0, 0, null);
        }
        if (this.rightImage != null) {
            g2d.drawImage((Image)this.rightImage, this.getWidth() - this.rightImage.getWidth(), 0, null);
        }
        g2d.drawImage(this.shadowImage, 0, this.height - 10, null);
        g2d.drawImage((Image)this.titleImage, 0, 0, null);
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public void setGradient(Color gradientColorFrom, Color gradientColorTo) {
        this.gradientColorFrom = gradientColorFrom;
        this.gradientColorTo = gradientColorTo;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setLeftImage(URL iconUrl) {
        try {
            if (iconUrl != null) {
                this.leftImage = this.readImage(iconUrl);
            }
        }
        catch (Throwable oops) {
            logger.fatal((Object)oops);
        }
    }

    public void setRightImage(URL iconUrl) {
        try {
            if (iconUrl != null) {
                this.rightImage = this.readImage(iconUrl);
            }
        }
        catch (Throwable oops) {
            logger.fatal((Object)oops);
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleHasChanged = true;
        this.repaint();
    }

    private void createShadow() {
        BufferedImage image = new BufferedImage(4096, 50, 2);
        Graphics2D shadow2D = (Graphics2D)image.getGraphics();
        shadow2D.setPaint(Color.DARK_GRAY);
        shadow2D.fillRect(0, 25, 4096, 9);
        image = BlurFilter.boxBlur(image, 9);
        this.shadowImage = this.createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(9, 32, 4087, 10)));
    }

    private void createTitleImage(String title) {
        this.width = this.computeWidth(title);
        BufferedImage image = new BufferedImage(this.width, this.height - 10, 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(this.getFont());
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int length = fontMetrics.stringWidth(title);
        int offset = 1;
        int xpos = this.width / 2 - length / 2;
        if (this.alignment == Alignment.LEFT) {
            xpos = fontMetrics.getAscent();
        }
        int ypos = this.height / 2 + (fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        g2d.setPaint(Color.GRAY);
        g2d.drawString(title, xpos + offset, ypos + offset);
        BufferedImage blurImage = BlurFilter.gaussianBlur(image, 5);
        g2d = (Graphics2D)blurImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(this.getFont());
        g2d.setPaint(this.getForeground());
        g2d.drawString(title, xpos, ypos);
        this.titleImage = blurImage;
    }

    private int computeWidth(String title) {
        BufferedImage image = new BufferedImage(1024, 100, 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setFont(this.getFont());
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int width = fontMetrics.getAscent() * 2 + fontMetrics.stringWidth(title);
        if (this.getWidth() > width) {
            width = this.getWidth();
        }
        return width;
    }

    private BufferedImage readImage(URL iconUrl) {
        try {
            return ImageIO.read(iconUrl);
        }
        catch (IOException e) {
            return null;
        }
    }
}

