/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;

public class StatusBar
extends GridPanel {
    private static final long serialVersionUID = 1L;
    private int pageIndex = 1;
    private int numberOfPages = 1;
    private JiveFactory jive = JiveFactory.getInstance();
    private ResourceBundle res = this.jive.getResourceBundle();
    private JLabel pageInfo;

    public void createGui() {
        this.addPageInfo();
        this.addHorizontalGlue();
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setNumberOfPages(int numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    private void addPageInfo() {
        this.pageInfo = new JLabel(this.createPageInfoText());
        this.pageInfo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.addComponent((JComponent)this.pageInfo, Anchor.WEST);
    }

    private String createPageInfoText() {
        return " " + ResourceServices.getString(this.res, "page") + " " + this.pageIndex + "/" + this.numberOfPages + " ";
    }

    public void updatePageInfo(int pageIndex, int numberOfPages) {
        this.pageIndex = pageIndex;
        this.numberOfPages = numberOfPages;
        this.pageInfo.setText(this.createPageInfoText());
    }
}

