/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.CanceledException;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveExceptionHandler;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.text.TextServices;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.StageProgressListener;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;

public class StageProgressPanel
extends GridPanel
implements StageProgressListener {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(StageProgressPanel.class);
    private DateFormat df;
    private JEditorPane info;
    private JProgressBar mainBar;
    private JProgressBar stepBar;
    private ResourceBundle res;
    private String title;
    private URL bgImgUrl;
    private JiveFactory wm;
    private int currentStage = 0;
    private int prepareCounter;
    private int progressMaximum = 1;
    private int progressValue;
    private int stageCount = 1;
    private long progressStartTime = 0L;
    private long lastUpdate;

    public StageProgressPanel(Frame parent, String title) {
        this.init(parent, title);
        this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public void finished(String text) {
        FinishedEventHandler handler = new FinishedEventHandler(text);
        this.execute(handler);
    }

    public final int getProgressMaximum() {
        return this.progressMaximum;
    }

    public final long getProgressStartTime() {
        return this.progressStartTime;
    }

    @Override
    public final boolean isCanceled() {
        return false;
    }

    @Override
    public void nextStage() {
        logger.debug((Object)"nextStep");
        this.mainBar.setValue(this.currentStage);
        ++this.currentStage;
        this.resetStage();
    }

    @Override
    public boolean progress(ProgressEvent event) {
        ProgressEventHandler handler = new ProgressEventHandler(event);
        if (event.getStage() == 1) {
            ++this.prepareCounter;
        }
        if (event.getStage() == 2 && event.getConsider()) {
            ++this.progressValue;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            handler.run();
        } else {
            try {
                long now = System.currentTimeMillis();
                int i = 333;
                if (now - this.lastUpdate > (long)i) {
                    SwingUtilities.invokeAndWait(handler);
                    this.lastUpdate = now;
                }
            }
            catch (InterruptedException oops) {
                throw new CanceledException();
            }
            catch (Exception oops) {
                JiveExceptionHandler.handle(oops);
            }
        }
        return true;
    }

    public void setMainIndeterminate(boolean indeterminate) {
        this.mainBar.setIndeterminate(indeterminate);
        this.mainBar.setStringPainted(!indeterminate);
    }

    @Override
    public void setProgressMaximum(int progressMaximum) {
        if (progressMaximum < 1) {
            progressMaximum = 1;
        }
        logger.debug((Object)("progressMaximum = " + progressMaximum));
        this.progressMaximum = progressMaximum;
        this.progressValue = 0;
        this.stepBar.setMaximum(progressMaximum);
    }

    public void setProgressStartTime(long progressStartTime) {
        this.progressStartTime = progressStartTime;
    }

    @Override
    public void setStageCount(int stepCount) {
        this.stageCount = stepCount;
        this.mainBar.setMaximum(stepCount);
    }

    public void setText(String msg) {
        TextServices.setText(this.info, msg, this.bgImgUrl);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public final boolean veto(ProgressEvent progressEvent) {
        return false;
    }

    private void execute(Runnable handler) {
        if (SwingUtilities.isEventDispatchThread()) {
            handler.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(handler);
            }
            catch (InterruptedException oops) {
                JiveExceptionHandler.handle(oops);
            }
            catch (InvocationTargetException oops) {
                JiveExceptionHandler.handle(oops);
            }
        }
    }

    private String formatElapsedTime() {
        long now = System.currentTimeMillis();
        long elapsed = now - this.progressStartTime;
        long eh = (elapsed /= 1000L) / 3600L;
        long em = (elapsed %= 3600L) / 60L;
        long es = elapsed % 60L;
        StringBuffer buffer = new StringBuffer();
        buffer.append(eh);
        buffer.append(':');
        if (em < 10L) {
            buffer.append('0');
        }
        buffer.append(em);
        buffer.append(':');
        if (es < 10L) {
            buffer.append('0');
        }
        buffer.append(es);
        return buffer.toString();
    }

    private String formatEstimatedTime() {
        int max = this.progressMaximum * this.stageCount;
        int current = this.progressMaximum * this.currentStage + this.progressValue;
        long now = System.currentTimeMillis();
        long elapsed = now - this.progressStartTime;
        long time = 0L;
        if (current > 0) {
            time = elapsed / (long)current * (long)max;
        }
        time = this.progressStartTime + time;
        return this.df.format(new Date(time));
    }

    private void init(Frame parent, String title) {
        this.wm = JiveFactory.getInstance();
        this.res = this.wm.getResourceBundle();
        this.bgImgUrl = this.wm.getBackgroundImageUrl();
        this.df = DateFormat.getDateTimeInstance(3, 3, this.res.getLocale());
        this.prepareCounter = 0;
        this.progressStartTime = System.currentTimeMillis();
        this.info = new JEditorPane();
        this.info.setPreferredSize(new Dimension(600, 200));
        this.info.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.info.setEditable(false);
        this.info.setFocusable(false);
        this.addComponent((JComponent)this.info, Anchor.NORTHWEST, Fill.BOTH);
        this.incrRow();
        this.stepBar = new JProgressBar();
        this.stepBar.setIndeterminate(false);
        this.stepBar.setStringPainted(true);
        this.addComponent((JComponent)this.stepBar, Anchor.NORTHWEST, Fill.HORIZONTAL);
        this.incrRow();
        this.mainBar = new JProgressBar();
        this.mainBar.setIndeterminate(false);
        this.mainBar.setStringPainted(true);
        this.addComponent((JComponent)this.mainBar, Anchor.NORTHWEST, Fill.HORIZONTAL);
        this.incrRow();
    }

    private void resetStage() {
        logger.debug((Object)"reset");
        this.prepareCounter = 0;
        this.progressMaximum = 1;
        this.progressValue = 0;
        this.stepBar.setMaximum(100);
        this.stepBar.setValue(0);
    }

    class ProgressEventHandler
    implements Runnable {
        private final ProgressEvent event;

        public ProgressEventHandler(ProgressEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            StringBuffer buffer;
            int stage = this.event.getStage();
            String action = this.event.getAction();
            if (action != null) {
                if ((action = action.trim()).startsWith("<html>")) {
                    action = StringServices.cutPrefix(action, "<html>");
                    action = StringServices.cutSuffix(action, "</html>");
                } else {
                    action = "<p>" + StringServices.shorten(action, 80) + "</p>";
                }
            }
            this.event.getUserObject();
            if (stage == 1) {
                StageProgressPanel.this.stepBar.setIndeterminate(true);
                StageProgressPanel.this.stepBar.setStringPainted(false);
                buffer = new StringBuffer();
                buffer.append("<html><h3>");
                if (StageProgressPanel.this.title == null) {
                    buffer.append(ResourceServices.getString(StageProgressPanel.this.res, "C_PREPARE"));
                } else {
                    buffer.append(StageProgressPanel.this.title);
                }
                buffer.append("</h3><table width='100%'><tr><th width='25%'>");
                buffer.append(ResourceServices.getString(StageProgressPanel.this.res, "C_STAGE"));
                buffer.append("</th><th width='25%'></th><th width='25%'>");
                buffer.append(ResourceServices.getString(StageProgressPanel.this.res, "C_START_TIME"));
                buffer.append("</th><th width='25%'>");
                buffer.append(ResourceServices.getString(StageProgressPanel.this.res, "C_ELAPSED_TIME"));
                buffer.append("</th><th width='25%'>");
                buffer.append("");
                buffer.append("</th></tr><tr><td>");
                buffer.append(StageProgressPanel.this.currentStage);
                buffer.append('/');
                buffer.append(StageProgressPanel.this.stageCount);
                buffer.append("</td><td>");
                buffer.append(StageProgressPanel.this.prepareCounter);
                buffer.append("</td><td>");
                buffer.append(StageProgressPanel.this.df.format(new Date(StageProgressPanel.this.progressStartTime)));
                buffer.append("</td><td>");
                buffer.append(StageProgressPanel.this.formatElapsedTime());
                buffer.append("</td></tr></table>");
                if (action != null && action.length() > 0) {
                    buffer.append(action);
                }
                buffer.append("</html>");
                StageProgressPanel.this.setText(buffer.toString());
            }
            if (stage == 2) {
                StageProgressPanel.this.stepBar.setIndeterminate(false);
                StageProgressPanel.this.stepBar.setStringPainted(true);
                if (this.event.getConsider()) {
                    StageProgressPanel.this.stepBar.setValue(StageProgressPanel.this.progressValue);
                }
                buffer = new StringBuffer();
                buffer.append("<html><h3>");
                if (StageProgressPanel.this.title == null) {
                    buffer.append(ResourceServices.getString(StageProgressPanel.this.res, "C_EXECUTING"));
                } else {
                    buffer.append(StageProgressPanel.this.title);
                }
                buffer.append("</h3><table width='100%'><tr><th width='25%'>");
                buffer.append(ResourceServices.getString(StageProgressPanel.this.res, "C_STAGE"));
                buffer.append("</th><th width='25%'></th><th width='25%'>");
                buffer.append(ResourceServices.getString(StageProgressPanel.this.res, "C_START_TIME"));
                buffer.append("</th><th width='25%'>");
                buffer.append(ResourceServices.getString(StageProgressPanel.this.res, "C_ELAPSED_TIME"));
                buffer.append("</th><th width='25%'>");
                buffer.append(ResourceServices.getString(StageProgressPanel.this.res, "C_ESTIMATED_TIME"));
                buffer.append("</th></tr><tr><td>");
                buffer.append(StageProgressPanel.this.currentStage);
                buffer.append('/');
                buffer.append(StageProgressPanel.this.stageCount);
                buffer.append("</td><td>");
                buffer.append(StageProgressPanel.this.progressValue);
                buffer.append('/');
                buffer.append(StageProgressPanel.this.progressMaximum);
                buffer.append("</td><td>");
                buffer.append(StageProgressPanel.this.df.format(new Date(StageProgressPanel.this.progressStartTime)));
                buffer.append("</td><td>");
                buffer.append(StageProgressPanel.this.formatElapsedTime());
                buffer.append("</td><td>");
                buffer.append(StageProgressPanel.this.formatEstimatedTime());
                buffer.append("</td></tr></table>");
                if (action != null && action.length() > 0) {
                    buffer.append(action);
                }
                buffer.append("</html>");
                StageProgressPanel.this.setText(buffer.toString());
            }
        }
    }

    class FinishedEventHandler
    implements Runnable {
        private final String text;

        public FinishedEventHandler(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            StageProgressPanel.this.currentStage = 0;
            StageProgressPanel.this.stageCount = 1;
            StageProgressPanel.this.resetStage();
            StageProgressPanel.this.stepBar.setValue(StageProgressPanel.this.stepBar.getMaximum());
            StageProgressPanel.this.stepBar.setIndeterminate(false);
            StageProgressPanel.this.mainBar.setValue(StageProgressPanel.this.mainBar.getMaximum());
            StageProgressPanel.this.mainBar.setIndeterminate(false);
            if (this.text == null) {
                StageProgressPanel.this.setText("<html><h3>" + ResourceServices.getString(StageProgressPanel.this.res, "C_FINISHED"));
            } else {
                StageProgressPanel.this.setText(this.text);
            }
        }
    }
}

