/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.InsetsUIResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.dialog.ExceptionBox;
import org.dbdoclet.jive.filter.BlurFilter;
import org.dbdoclet.jive.widget.sidebar.SideBarButton;
import org.dbdoclet.jive.widget.sidebar.SideBarGroup;

public class SideBar
extends JPanel
implements ActionListener,
ChangeListener {
    private static Log logger = LogFactory.getLog(SideBar.class);
    private static final long serialVersionUID = 1L;
    public static final int BUTTON_WIDTH = 150;
    public static final int BUTTON_HEIGHT = 90;
    private boolean isVisible = true;
    private SideBarButton activeButton;
    private final Hashtable<String, SideBarButton> buttonMap = new Hashtable();
    private final ArrayList<SideBarGroup> groupList = new ArrayList();
    private JTabbedPane tabbedPane;

    public SideBar() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("toggleSideBar", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                SideBar.this.toggleVisibility();
            }
        });
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke("F9"), "toggleSideBar");
        this.setBackground(new Color(223, 223, 223));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            Object obj = event.getSource();
            if (obj instanceof SideBarButton) {
                this.setSelected((SideBarButton)obj);
            }
        }
        catch (Throwable oops) {
            ExceptionBox ebox = new ExceptionBox(oops);
            ebox.setVisible(true);
            ebox.toFront();
        }
    }

    public void addButton(SideBarButton button) {
        this.addButton(SideBarGroup.DEFAULT_GROUP, button, null);
    }

    public void addButton(SideBarButton button, String name) {
        this.addButton(SideBarGroup.DEFAULT_GROUP, button, name);
    }

    public void addButton(SideBarGroup group, SideBarButton button, String name) {
        if (group == null) {
            throw new IllegalArgumentException("The argument groupName must not be null!");
        }
        if (!this.groupList.contains(group)) {
            this.groupList.add(group);
        }
        button.addActionListener(this);
        button.setSideBar(this);
        group.addButton(button);
        if (name != null && name.length() > 0) {
            this.buttonMap.put(name, button);
        }
    }

    public void clear() {
        this.buttonMap.clear();
        this.groupList.clear();
    }

    public JButton findButton(String name) {
        return this.buttonMap.get(name);
    }

    public int getSelectedTab() {
        if (this.tabbedPane != null) {
            return this.tabbedPane.getSelectedIndex();
        }
        return 0;
    }

    public void prepare() {
        if (this.groupList.size() == 0) {
            return;
        }
        this.removeAll();
        if (this.groupList.size() == 1) {
            this.initGroup(this);
            this.fillGroup(this, this.groupList.get(0).getButtonList());
        }
        if (this.groupList.size() > 1) {
            this.createTabbedSideBar();
        }
        this.invalidate();
        this.repaint();
    }

    public boolean removeButton(String name) {
        JButton button = this.buttonMap.get(name);
        if (button == null) {
            return false;
        }
        this.buttonMap.remove(name);
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        logger.debug((Object)("setEnabled: " + enabled));
        int index = 0;
        while (index < 5) {
            try {
                for (JButton jButton : this.buttonMap.values()) {
                    if (jButton.isEnabled() == enabled) continue;
                    jButton.setEnabled(enabled);
                }
                index = 5;
            }
            catch (ConcurrentModificationException oops) {
                oops.printStackTrace();
                ++index;
            }
        }
        if (this.tabbedPane != null && this.tabbedPane.isEnabled() != enabled) {
            this.tabbedPane.setEnabled(enabled);
        }
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
        }
    }

    public void setSelected(SideBarButton button) {
        if (this.activeButton != null) {
            this.activeButton.isActive(false);
        }
        if (button != null) {
            this.activeButton = button;
            this.activeButton.isActive(true);
        } else {
            this.activeButton = null;
        }
    }

    public void setSelected(String name) {
        SideBarButton button = this.buttonMap.get(name);
        if (button != null) {
            this.setSelectedTab(button.getGroup().getTabIndex());
            this.setSelected(button);
        }
    }

    public void setSelectedTab(int index) {
        if (this.tabbedPane != null && index >= -1 && index < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        SideBarButton button;
        SideBarGroup group;
        JTabbedPane tabbedPane = (JTabbedPane)event.getSource();
        int selectedIndex = tabbedPane.getSelectedIndex();
        if (selectedIndex > 0 && selectedIndex < this.groupList.size() && (group = this.groupList.get(selectedIndex)) != null && (button = group.getButtonList().get(0)) != null && !button.isSelected()) {
            button.doClick();
        }
    }

    public void toggleVisibility() {
        this.isVisible = !this.isVisible;
        this.setVisible(this.isVisible);
        this.repaint();
    }

    private synchronized void createTabbedSideBar() {
        this.setLayout(new GridBagLayout());
        Insets insets = (Insets)UIManager.get("TabbedPane.tabInsets");
        UIManager.put("TabbedPane.tabInsets", new InsetsUIResource(1, 1, 1, 1));
        this.tabbedPane = new JTabbedPane(2);
        this.tabbedPane.setName("tp.sidebar");
        this.tabbedPane.setBackground(new Color(223, 223, 223));
        this.tabbedPane.addChangeListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.tabbedPane, gbc);
        int index = 0;
        Collections.sort(this.groupList);
        for (SideBarGroup group : this.groupList) {
            JPanel groupPanel = new JPanel();
            this.initGroup(groupPanel);
            this.fillGroup(groupPanel, group.getButtonList());
            ImageIcon icon = this.createVerticalLabel(group.getName());
            this.tabbedPane.addTab(null, icon, groupPanel);
            group.setTabIndex(index++);
        }
        UIManager.put("TabbedPane.tabInsets", insets);
    }

    private ImageIcon createVerticalLabel(String text) {
        Font font = this.getFont().deriveFont(1);
        BufferedImage image = new BufferedImage(300, 300, 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setFont(font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int height = fontMetrics.getHeight();
        int width = fontMetrics.stringWidth(text) + 2 * fontMetrics.getAscent();
        int xpos = fontMetrics.getAscent();
        int ypos = height;
        int tx = 0;
        int ty = width;
        int offset = 1;
        int blur = 3;
        double theta = -1.5707963267948966;
        image = image.getSubimage(0, 0, width, width);
        g2d = (Graphics2D)image.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(font);
        g2d.translate(tx, ty);
        g2d.rotate(theta);
        g2d.setPaint(Color.GRAY);
        g2d.drawString(text, xpos + offset, ypos + offset);
        image = BlurFilter.gaussianBlur(image, blur);
        g2d = (Graphics2D)image.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(font);
        g2d.translate(tx, ty);
        g2d.rotate(theta);
        g2d.setPaint(Color.black);
        g2d.drawString(text, xpos, ypos);
        image = image.getSubimage(0, 0, height + offset + blur + 1, image.getHeight());
        return new ImageIcon(image);
    }

    private void fillGroup(JPanel groupPanel, ArrayList<SideBarButton> buttonList) {
        if (groupPanel == null) {
            throw new IllegalArgumentException("The argument groupPanel must not be null!");
        }
        Collections.sort(buttonList);
        for (JButton jButton : buttonList) {
            groupPanel.add(jButton);
        }
    }

    private void initGroup(JPanel panel) {
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        panel.setLayout(boxLayout);
        panel.setBackground(new Color(223, 223, 223));
        panel.setMinimumSize(new Dimension(150, 450));
        panel.setPreferredSize(new Dimension(150, 450));
        panel.setBorder(BorderFactory.createLoweredBevelBorder());
    }
}

