/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import org.dbdoclet.jive.filter.BlurFilter;

public class RichLabel
extends JLabel {
    private static final double FACTOR = 1.3;
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;

    public RichLabel(String text) {
        super(text);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.width > 0 && this.height > 0) {
            return new Dimension(this.width, this.height);
        }
        Dimension dim = super.getPreferredSize();
        dim = new Dimension((int)((double)dim.width * 1.3), (int)((double)dim.height * 1.3));
        return dim;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Font font = this.getFont();
        int offset = font.getSize() / 15;
        FontMetrics fontMetrics = g.getFontMetrics();
        this.width = (int)((double)fontMetrics.stringWidth(this.getText()) * 1.3);
        this.height = (int)((double)fontMetrics.getHeight() * 1.3);
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(font);
        fontMetrics = g2d.getFontMetrics();
        int length = fontMetrics.stringWidth(this.getText());
        int xpos = this.width / 2 - length / 2;
        xpos = 0;
        int ypos = this.height / 2 + (fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        g2d.setPaint(Color.GRAY);
        g2d.drawString(this.getText(), xpos + offset, ypos + offset);
        BufferedImage blurImage = BlurFilter.gaussianBlur(image, 7);
        g2d = (Graphics2D)blurImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(this.getFont());
        g2d.setPaint(this.getForeground());
        g2d.drawString(this.getText(), 0, ypos);
        g.drawImage(blurImage, 0, 0, null);
    }
}

