/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.dialog.property.Property;
import org.dbdoclet.jive.widget.GridPanel;

public class PropertyPanel
extends GridPanel {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(PropertyPanel.class);
    private Font plainFont;
    private JTable propertyTable;
    private PropertyTableData propertyModel;
    private TableColumn labelColumn;
    private TableColumn widgetColumn;
    private HashMap<String, Property> propertyMap;

    public PropertyPanel() {
        this.init();
    }

    public void addProperty(Property property) {
        if (property != null) {
            this.addPropertyTableRow(property);
        }
    }

    private void addPropertyTableRow(Property property) {
        String label = property.getLabel();
        JLabel widget = new JLabel(label);
        Dimension widgetSize = widget.getPreferredSize();
        int width = (int)widgetSize.getWidth() + 10;
        logger.debug((Object)("width=" + width));
        int maxWidth = this.labelColumn.getWidth();
        if (width > maxWidth) {
            this.labelColumn.setWidth(width);
            this.labelColumn.setPreferredWidth(width);
        }
        property.setPanel(this);
        this.propertyModel.add(property);
        this.propertyModel.fireTableDataChanged();
    }

    public void init() {
        JLabel label = new JLabel();
        this.plainFont = label.getFont();
        this.plainFont = this.plainFont.deriveFont(0);
        this.propertyModel = new PropertyTableData();
        this.propertyTable = new JTable();
        this.propertyTable.setBackground(Color.white);
        this.propertyTable.setAutoCreateColumnsFromModel(false);
        this.propertyTable.setModel(this.propertyModel);
        this.propertyTable.setRowHeight(20);
        PropertyTableColumnData[] columns = this.propertyModel.getColumns();
        PropertyTableCellRenderer renderer = new PropertyTableCellRenderer();
        PropertyTableCellEditor editor = new PropertyTableCellEditor(this);
        this.labelColumn = new TableColumn(0, columns[0].width, renderer, editor);
        this.propertyTable.addColumn(this.labelColumn);
        this.widgetColumn = new TableColumn(1, columns[1].width, renderer, editor);
        this.propertyTable.addColumn(this.widgetColumn);
        this.addComponent((JComponent)new JScrollPane(this.propertyTable), Anchor.WEST, Fill.BOTH);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Dimension size = this.propertyTable.getPreferredSize();
            size.width = this.labelColumn.getPreferredWidth() + this.widgetColumn.getPreferredWidth();
            logger.debug((Object)("width=" + size.width));
            this.propertyTable.setPreferredScrollableViewportSize(size);
        }
        super.setVisible(visible);
    }

    public void stopEditing() {
        int row = this.propertyTable.getEditingRow();
        int col = this.propertyTable.getEditingColumn();
        if (row >= 0 && col >= 0) {
            TableCellEditor editor = this.propertyTable.getCellEditor(row, col);
            editor.stopCellEditing();
        }
    }

    public void clear() {
        this.propertyModel = new PropertyTableData();
        this.propertyTable.setModel(this.propertyModel);
    }

    public void update() {
        if (this.propertyModel != null) {
            this.propertyModel.fireTableDataChanged();
        }
    }

    public void addProperty(String key, Property property) {
        this.addProperty(property);
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        this.propertyMap.put(key, property);
    }

    public Property getProperty(String key) {
        if (this.propertyMap != null) {
            return this.propertyMap.get(key);
        }
        return null;
    }

    class PropertyTableData
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final PropertyTableColumnData[] columns;
        private final Vector<Property> vector;

        public PropertyTableData() {
            this.columns = new PropertyTableColumnData[]{new PropertyTableColumnData("Property", 100, 2), new PropertyTableColumnData("Value", 100, 2)};
            this.vector = new Vector();
        }

        public void add(Property property) {
            this.vector.add(property);
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column].title;
        }

        public PropertyTableColumnData[] getColumns() {
            return this.columns;
        }

        public Property getPropertyAt(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.vector.size()) {
                return null;
            }
            Property property = this.vector.get(rowIndex);
            return property;
        }

        @Override
        public int getRowCount() {
            return this.vector.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || rowIndex >= this.vector.size()) {
                return "";
            }
            Property property = this.vector.get(rowIndex);
            if (columnIndex == 0) {
                return property.getLabel();
            }
            logger.debug((Object)("[" + rowIndex + "," + columnIndex + "] " + property.getValue()));
            return property.getValue();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Property property = this.vector.get(rowIndex);
            logger.debug((Object)("[" + rowIndex + "," + columnIndex + "] Property=" + property + ", Value=" + value));
            property.setValue(value);
        }

        public void clear() {
            this.vector.clear();
        }
    }

    class PropertyTableColumnData {
        public String title;
        public int width;
        public int alignment;

        public PropertyTableColumnData(String title, int width, int alignment) {
            this.title = title;
            this.width = width;
            this.alignment = alignment;
        }
    }

    class PropertyTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private final GridBagConstraints gbc;

        public PropertyTableCellRenderer() {
            this.setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.anchor = 17;
            this.gbc.fill = 1;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(false);
            this.removeAll();
            PropertyTableData model = (PropertyTableData)table.getModel();
            Property property = model.getPropertyAt(row);
            this.setToolTipText(property.getToolTip());
            if (column == 0) {
                JLabel label = new JLabel();
                label.setFont(label.getFont().deriveFont(0));
                label.setBackground(Color.white);
                label.setText(value.toString());
                label.setEnabled(property.isEnabled());
                this.add((Component)label, this.gbc);
                return this;
            }
            Component comp = property.getRenderer(value);
            comp.setBackground(Color.white);
            this.add(comp, this.gbc);
            return this;
        }
    }

    class PropertyTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private Property property;

        public PropertyTableCellEditor(PropertyPanel dlg) {
        }

        @Override
        public Object getCellEditorValue() {
            return this.property.getEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            PropertyTableData model = (PropertyTableData)table.getModel();
            this.property = model.getPropertyAt(row);
            Component component = this.property.getEditor(value);
            component.setBackground(Color.white);
            component.setEnabled(this.property.isEnabled());
            panel.add(component, gbc);
            return panel;
        }
    }
}

