/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.io.FileSet;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.model.LabelItem;
import org.dbdoclet.jive.model.PathListModel;
import org.dbdoclet.jive.widget.pathlist.FilterTypeRenderer;
import org.dbdoclet.jive.widget.pathlist.StatusRenderer;
import org.dbdoclet.service.ResourceServices;

public class PathList
extends JTable
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int FILE_FILTER_MASK = 1;
    public static final int DIRECTORY_FILTER_MASK = 2;
    public static final int PACKAGE_FILTER_MASK = 4;
    private static Log logger = LogFactory.getLog(PathList.class);
    private static ResourceBundle res;
    private final HashMap<String, String> defaultFilterMap;
    private final PathListModel model;
    private final TableColumn caseSensitiveColumn;
    private final TableColumn filterColumn;
    private final TableColumn filterTypeColumn;
    private final TableColumn pathColumn;
    private final TableColumn statusColumn;
    private final TableColumnModel columnModel;
    private final JiveFactory widgetMap;
    private final FilterTypeRenderer filterTypeRenderer;
    private final DefaultCellEditor filterTypeEditor;
    private final StatusRenderer statusRenderer;

    public PathList(JiveFactory widgetMap) {
        this(widgetMap, 1);
    }

    public PathList(JiveFactory widgetMap, int filterMask) {
        if (widgetMap == null) {
            throw new IllegalArgumentException("The argument widgetMap must not be null!");
        }
        this.widgetMap = widgetMap;
        res = widgetMap.getResourceBundle();
        this.model = new PathListModel(widgetMap);
        this.setModel(this.model);
        this.setRowHeight(20);
        this.columnModel = this.getColumnModel();
        this.columnModel.getColumn(0);
        this.pathColumn = this.columnModel.getColumn(1);
        this.statusColumn = this.columnModel.getColumn(2);
        this.caseSensitiveColumn = this.columnModel.getColumn(4);
        this.filterTypeColumn = this.columnModel.getColumn(3);
        this.filterColumn = this.columnModel.getColumn(5);
        this.pathColumn.setPreferredWidth(300);
        this.statusColumn.setPreferredWidth(50);
        this.caseSensitiveColumn.setPreferredWidth(50);
        this.filterTypeColumn.setPreferredWidth(150);
        this.filterColumn.setPreferredWidth(150);
        JComboBox<LabelItem> filterTypeBox = new JComboBox<LabelItem>();
        filterTypeBox.addActionListener(this);
        filterTypeBox.setActionCommand("filter-changed");
        Font font = filterTypeBox.getFont();
        font = font.deriveFont(0);
        filterTypeBox.setFont(font);
        filterTypeBox.setBackground(this.getBackground());
        filterTypeBox.addItem(new LabelItem(ResourceServices.getString(res, "C_NO_FILTER"), new Integer(0)));
        if ((filterMask & 1) != 0) {
            filterTypeBox.addItem(new LabelItem(ResourceServices.getString(res, "C_INCLUDE_FILES"), new Integer(1)));
            filterTypeBox.addItem(new LabelItem(ResourceServices.getString(res, "C_EXCLUDE_FILES"), new Integer(2)));
        }
        if ((filterMask & 2) != 0) {
            filterTypeBox.addItem(new LabelItem(ResourceServices.getString(res, "C_INCLUDE_DIRECTORIES"), new Integer(3)));
            filterTypeBox.addItem(new LabelItem(ResourceServices.getString(res, "C_EXCLUDE_DIRECTORIES"), new Integer(4)));
        }
        if ((filterMask & 4) != 0) {
            filterTypeBox.addItem(new LabelItem(ResourceServices.getString(res, "C_INCLUDE_PACKAGES"), new Integer(5)));
            filterTypeBox.addItem(new LabelItem(ResourceServices.getString(res, "C_EXCLUDE_PACKAGES"), new Integer(6)));
        }
        this.defaultFilterMap = new HashMap();
        this.defaultFilterMap.put("include-files", "**/*");
        this.defaultFilterMap.put("exclude-files", "**/*");
        this.defaultFilterMap.put("include-packages", "**");
        this.defaultFilterMap.put("exclude-packages", "**");
        this.setAutoCreateRowSorter(true);
        this.filterTypeRenderer = new FilterTypeRenderer(this.model);
        this.filterTypeEditor = new DefaultCellEditor(filterTypeBox);
        this.statusRenderer = new StatusRenderer(this.model);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 2) {
            return this.statusRenderer;
        }
        if (column == 3) {
            return this.filterTypeRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 3) {
            return this.filterTypeEditor;
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        FileSet entry;
        String filter;
        int rowIndex;
        String cmd = event.getActionCommand();
        logger.debug((Object)("cmd=" + cmd));
        if (cmd.equals("filter-changed") && (rowIndex = this.getSelectedRow()) != -1 && ((filter = (entry = this.model.getEntry(rowIndex)).getFilter()) == null || filter.trim().length() == 0)) {
            int filterType = entry.getFilterType();
            switch (filterType) {
                case 1: {
                    entry.setFilter(this.defaultFilterMap.get("include-files"));
                    break;
                }
                case 2: {
                    entry.setFilter(this.defaultFilterMap.get("exclude-files"));
                    break;
                }
                case 5: {
                    entry.setFilter(this.defaultFilterMap.get("include-packages"));
                    break;
                }
                case 6: {
                    entry.setFilter(this.defaultFilterMap.get("exclude-packages"));
                    break;
                }
                default: {
                    entry.setFilter("");
                }
            }
            this.model.rowChanged(rowIndex);
        }
    }

    public void addEntry(FileSet fileset) {
        logger.debug((Object)("fileset=" + fileset));
        this.model.addEntry(fileset);
        if (this.widgetMap != null) {
            this.widgetMap.enableSaveWidgets();
        }
    }

    public void addEntry(String path) {
        logger.debug((Object)("path=" + path));
        this.model.addEntry(path);
        if (this.widgetMap != null) {
            this.widgetMap.enableSaveWidgets();
        }
    }

    public void changed() {
        this.model.changed();
    }

    public void clear() {
        this.model.clear();
    }

    public boolean contains(FileSet fileset) {
        return this.model.contains(fileset);
    }

    public void editSelected() {
        int row = this.getSelectedRow();
        if (row >= -1) {
            this.editCellAt(row, 1);
        }
    }

    public ArrayList<FileSet> getFileSets() {
        return this.model.getFileSets();
    }

    public int getPathCount() {
        return this.model.size();
    }

    public boolean isEmpty() {
        return this.model.size() == 0;
    }

    public void removeSelectedEntry() {
        int[] rows = this.getSelectedRows();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (int row : rows) {
            Integer id = (Integer)this.getValueAt(row, 0);
            idList.add(id);
        }
        Object object = idList.iterator();
        while (object.hasNext()) {
            Integer id = (Integer)object.next();
            this.model.removeEntry(id);
        }
        if (this.widgetMap != null) {
            this.widgetMap.enableSaveWidgets();
        }
    }

    public void setDefaultExcludeFilesFilter(String filter) {
        if (filter != null) {
            this.defaultFilterMap.put("exclude-files", filter);
        }
    }

    public void setDefaultExcludePackagesFilter(String filter) {
        if (filter != null) {
            this.defaultFilterMap.put("exclude-packages", filter);
        }
    }

    public void setDefaultIncludeFilesFilter(String filter) {
        if (filter != null) {
            this.defaultFilterMap.put("include-files", filter);
        }
    }

    public void setDefaultIncludePackagesFilter(String filter) {
        if (filter != null) {
            this.defaultFilterMap.put("include-packages", filter);
        }
    }

    public void setWorkingDir(File cwd) {
        if (cwd == null) {
            throw new IllegalArgumentException("The argument cwd may not be null!");
        }
        this.model.setWorkingDir(cwd);
    }

    public ArrayList<FileSet> findEntry(File path) {
        return this.model.findEntry(path);
    }
}

