/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.dbdoclet.jive.widget.AbstractTextField;

public class NumberTextField
extends AbstractTextField {
    private static final long serialVersionUID = 1L;

    public NumberTextField(int cols) {
        super(cols);
    }

    public Integer getNumber() {
        String buffer = this.getText();
        if (buffer == null || buffer.trim().length() == 0) {
            return null;
        }
        return Integer.parseInt(buffer);
    }

    @Override
    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    class NumberDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        NumberDocument() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            char[] buffer = str.toCharArray();
            boolean valid = true;
            boolean fit = true;
            if (buffer.length + this.getLength() <= NumberTextField.this.getMaxLength()) {
                for (int i = 0; i < buffer.length; ++i) {
                    if (Character.isDigit(buffer[i])) continue;
                    valid = false;
                    break;
                }
            } else {
                fit = false;
            }
            if (valid && fit) {
                super.insertString(offset, str, a);
            } else {
                NumberTextField.this.getToolkit().beep();
            }
        }
    }
}

