/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.dbdoclet.io.MimeType;

public class MimeTypeListBox
extends JComboBox<MimeType> {
    private static final long serialVersionUID = 1L;
    private DefaultComboBoxModel<MimeType> model = new DefaultComboBoxModel();
    public static final int ALL = 1;
    public static final int PICTURES = 2;

    public MimeTypeListBox() {
        this.addAllMimeTypes();
        this.setModel(this.model);
    }

    public MimeType getSelectedMimeType() {
        return (MimeType)this.getSelectedItem();
    }

    public void setSelectedMimeType(String mimeType) {
        MimeType mimeTypeItem = MimeType.valueOf(mimeType);
        this.setSelectedItem(mimeTypeItem);
    }

    public void setMimeTypeGroup(int groupMode) {
        if (groupMode == 2) {
            this.model.removeAllElements();
            this.model.addElement(MimeType.GIF);
            this.model.addElement(MimeType.JPEG);
            this.model.addElement(MimeType.PNG);
        }
        if (groupMode == 1) {
            this.addAllMimeTypes();
        }
    }

    private void addAllMimeTypes() {
        this.model.removeAllElements();
        this.model.addElement(MimeType.CSV);
        this.model.addElement(MimeType.DOC);
        this.model.addElement(MimeType.DOCX);
        this.model.addElement(MimeType.GIF);
        this.model.addElement(MimeType.HTML);
        this.model.addElement(MimeType.JPEG);
        this.model.addElement(MimeType.MIDI);
        this.model.addElement(MimeType.MP3);
        this.model.addElement(MimeType.MPEG);
        this.model.addElement(MimeType.ODP);
        this.model.addElement(MimeType.ODS);
        this.model.addElement(MimeType.ODT);
        this.model.addElement(MimeType.PDF);
        this.model.addElement(MimeType.PNG);
        this.model.addElement(MimeType.POD);
        this.model.addElement(MimeType.PPT);
        this.model.addElement(MimeType.PPTX);
        this.model.addElement(MimeType.PPTM);
        this.model.addElement(MimeType.POTX);
        this.model.addElement(MimeType.WAV);
        this.model.addElement(MimeType.WMV);
        this.model.addElement(MimeType.XLS);
        this.model.addElement(MimeType.XLSX);
    }
}

