/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.util.Locale;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.dbdoclet.jive.model.LabelItem;

public class LanguageListBox
extends JComboBox<LabelItem> {
    private static final long serialVersionUID = 1L;
    private static Locale[] defLocaleList = null;
    private Locale ctxLocale;

    public LanguageListBox(Locale ctxLocale) {
        Locale[] localeList = defLocaleList;
        if (localeList == null) {
            String[] isoLanguageList = Locale.getISOLanguages();
            localeList = new Locale[isoLanguageList.length];
            for (int i = 0; i < isoLanguageList.length; ++i) {
                localeList[i] = new Locale(isoLanguageList[i]);
            }
        }
        this.init(ctxLocale, localeList);
    }

    public LanguageListBox(Locale ctxLocale, Locale[] localeList) {
        this.init(ctxLocale, localeList);
    }

    public static void setDefaultLocaleList(Locale[] defLocaleList) {
        LanguageListBox.defLocaleList = defLocaleList;
    }

    public void setSelectedLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        Locale languageLocale = new Locale(locale.getLanguage());
        this.setSelectedItem(new LabelItem(locale.getDisplayLanguage(this.ctxLocale), languageLocale));
    }

    public Locale getSelectedLocale() {
        Object obj = this.getSelectedItem();
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof LabelItem)) {
            return null;
        }
        LabelItem item = (LabelItem)obj;
        if ((obj = item.getValue()) instanceof Locale) {
            return (Locale)obj;
        }
        return null;
    }

    public void init(Locale ctxLocale, Locale[] localeList) {
        Locale locale;
        if (ctxLocale == null) {
            ctxLocale = Locale.getDefault();
        }
        if (localeList == null) {
            throw new IllegalArgumentException("The argument localeList must not be null!");
        }
        this.ctxLocale = ctxLocale;
        DefaultComboBoxModel<LabelItem> model = new DefaultComboBoxModel<LabelItem>();
        TreeMap<String, Locale> localeMap = new TreeMap<String, Locale>();
        for (int i = 0; i < localeList.length; ++i) {
            String language = localeList[i].getLanguage();
            String text = localeList[i].getDisplayLanguage(ctxLocale);
            locale = (Locale)localeMap.get(text);
            if (locale != null) continue;
            localeMap.put(text, new Locale(language));
        }
        for (String name : localeMap.keySet()) {
            locale = (Locale)localeMap.get(name);
            model.addElement(new LabelItem(locale.getDisplayLanguage(ctxLocale), locale));
        }
        this.setModel(model);
        this.setSelectedItem(new LabelItem(ctxLocale.getDisplayLanguage(ctxLocale), ctxLocale));
    }
}

