/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ImagePreview
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final int SIZE = 400;
    private ImageIcon image = null;
    private ImageIcon thumbnail = null;
    private File file = null;
    private int size = 400;

    public ImagePreview() {
        this(400);
    }

    public ImagePreview(int size) {
        this.setMinimumSize(new Dimension(size + 10, size + 10));
        this.setPreferredSize(new Dimension(size + 20, size + 20));
        this.setMaximumSize(new Dimension(size + 30, size + 30));
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    public int getImageWidth() {
        if (this.image != null) {
            return this.image.getIconWidth();
        }
        return 0;
    }

    public int getImageHeight() {
        if (this.image != null) {
            return this.image.getIconHeight();
        }
        return 0;
    }

    public void loadImage() {
        if (this.file == null) {
            this.image = null;
            this.thumbnail = null;
            return;
        }
        this.image = new ImageIcon(this.file.getPath());
        if (this.image != null) {
            this.thumbnail = this.image.getIconWidth() > this.size ? new ImageIcon(this.image.getImage().getScaledInstance(this.size, -1, 1)) : this.image;
        }
    }

    public void setImage(File imageFile) {
        this.thumbnail = null;
        this.file = imageFile;
        this.loadImage();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.white);
        Rectangle visibleRect = this.getVisibleRect();
        g.clearRect(0, 0, visibleRect.width, visibleRect.height);
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

