/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Colspan;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.Rowspan;
import org.dbdoclet.jive.border.BottomEtchedBorder;
import org.dbdoclet.jive.border.TopEtchedBorder;
import org.dbdoclet.jive.widget.GridCell;

public class GridPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ArrayList<JButton> buttonList;
    private GridCell cell;
    private GridBagConstraints constraints;
    private Insets insets = new Insets(4, 4, 4, 4);
    private int maxCol = 0;
    private int maxRow = 0;
    private int columnOffset = 0;
    private GridPanel rowPanel;
    private Image backgroundImage;
    private Color gradientFrom;
    private Color gradientTo;

    public GridPanel() {
        this(null, new Insets(4, 4, 4, 4));
    }

    public GridPanel(Insets insets) {
        this(null, insets);
    }

    public GridPanel(String title) {
        this(title, new Insets(4, 4, 4, 4));
    }

    public GridPanel(String title, Insets insets) {
        super(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.anchor = 17;
        if (insets != null) {
            this.insets = insets;
        }
        if (title != null) {
            this.setBorder(BorderFactory.createTitledBorder(title));
        }
        this.cell = new GridCell();
        this.buttonList = new ArrayList();
    }

    public static void lock(Container container, boolean flag) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component comp = container.getComponent(i);
            if (comp instanceof JList || comp instanceof JButton || comp instanceof JCheckBox || comp instanceof JComboBox || comp instanceof JSpinner || comp instanceof JTable || comp instanceof JLabel) {
                comp.setEnabled(flag);
                continue;
            }
            if (comp instanceof Container) {
                GridPanel.lock((Container)comp, flag);
                continue;
            }
            comp.setEnabled(flag);
        }
    }

    public void addButton(JButton button) {
        this.buttonList.add(button);
    }

    public void addComponent(JComponent comp) {
        this.addComponent(comp, Colspan.CS_1, Rowspan.RS_1, Anchor.WEST, Fill.NONE);
    }

    public void addComponent(JComponent comp, Anchor anchor) {
        this.addComponent(comp, Colspan.CS_1, Rowspan.RS_1, anchor, Fill.NONE, null);
    }

    public void addComponent(JComponent comp, Anchor anchor, Fill fill) {
        this.addComponent(comp, Colspan.CS_1, Rowspan.RS_1, anchor, fill, null);
    }

    public void addComponent(JComponent comp, Anchor anchor, Fill fill, Insets insets) {
        this.addComponent(comp, Colspan.CS_1, Rowspan.RS_1, anchor, fill, insets);
    }

    public void addComponent(JComponent comp, Colspan width) {
        this.addComponent(comp, width, Rowspan.RS_1, Anchor.WEST, Fill.NONE);
    }

    public void addComponent(JComponent comp, Colspan width, Anchor anchor) {
        this.addComponent(comp, width, Rowspan.RS_1, anchor, Fill.NONE);
    }

    public void addComponent(JComponent comp, Colspan width, Anchor anchor, Fill fill) {
        this.addComponent(comp, width, Rowspan.RS_1, anchor, fill);
    }

    public void addComponent(JComponent comp, Colspan width, Rowspan height) {
        this.addComponent(comp, width, height, Anchor.WEST, Fill.NONE);
    }

    public void addComponent(JComponent comp, Colspan width, Rowspan height, Anchor anchor) {
        this.addComponent(comp, width, height, anchor, Fill.NONE);
    }

    public void addComponent(JComponent comp, Colspan width, Rowspan height, Anchor anchor, Fill fill) {
        this.addComponent(comp, width, height, anchor, fill, null);
    }

    public void addComponent(JComponent comp, Colspan width, Rowspan height, Anchor anchor, Fill fill, Insets insets) {
        if (comp == null) {
            throw new IllegalArgumentException("The argument comp may not be null!");
        }
        if (width == null) {
            throw new IllegalArgumentException("The argument width must not be null!");
        }
        if (height == null) {
            throw new IllegalArgumentException("The argument height must not be null!");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("The argument anchor must not be null!");
        }
        if (fill == null) {
            throw new IllegalArgumentException("The argument fill must not be null!");
        }
        if (this.cell.getCol() > this.maxCol) {
            this.maxCol = this.cell.getCol();
        }
        if (this.cell.getRow() > this.maxRow) {
            this.maxRow = this.cell.getRow();
        }
        this.constraints.gridx = this.cell.getCol();
        this.constraints.gridy = this.cell.getRow();
        this.constraints.gridwidth = width.getValue();
        this.constraints.gridheight = height.getValue();
        this.constraints.anchor = anchor.getGbc();
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = fill.getGbc();
        switch (this.constraints.fill) {
            case 0: {
                this.constraints.weightx = 0.0;
                this.constraints.weighty = 0.0;
                break;
            }
            case 1: {
                this.constraints.weightx = 1.0;
                this.constraints.weighty = 1.0;
                break;
            }
            case 2: {
                this.constraints.weightx = 1.0;
                this.constraints.weighty = 0.0;
                break;
            }
            case 3: {
                this.constraints.weightx = 0.0;
                this.constraints.weighty = 1.0;
                break;
            }
            default: {
                this.constraints.weightx = 0.0;
                this.constraints.weighty = 0.0;
            }
        }
        this.constraints.insets = insets != null ? insets : this.insets;
        if (this.rowPanel != null) {
            this.rowPanel.addComponent(comp, anchor, fill);
        } else {
            this.add((Component)comp, this.constraints);
            this.cell.incrCol(width.getValue());
        }
    }

    public void addComponent(JComponent comp, Fill fill) {
        this.addComponent(comp, Colspan.CS_1, Rowspan.RS_1, Anchor.WEST, fill, null);
    }

    public void addComponent(JComponent comp, Rowspan height, Anchor anchor) {
        this.addComponent(comp, Colspan.CS_1, height, anchor, Fill.NONE);
    }

    public void addComponent(JComponent comp, Rowspan height, Anchor anchor, Fill fill) {
        this.addComponent(comp, Colspan.CS_1, height, anchor, fill);
    }

    public void addHorizontalGlue() {
        JLabel label = new JLabel();
        this.addComponent(label, new Colspan(this.maxCol + 1), Rowspan.RS_1, Anchor.CENTER, Fill.HORIZONTAL);
    }

    public void addLabeledComponent(JLabel label, JComponent component) {
        this.addLabeledComponent(label, component, Fill.NONE);
    }

    public void addLabeledComponent(JLabel label, JComponent component, Fill fill) {
        if (label == null) {
            throw new IllegalArgumentException("The argument label may not be null!");
        }
        if (component == null) {
            throw new IllegalArgumentException("The argument comboBox must not be null!");
        }
        this.addComponent(label);
        this.addComponent(component, fill);
    }

    public void addLabeledComponent(String labelText, JComponent component) {
        JiveFactory jf = JiveFactory.getInstance();
        JLabel label = jf.createLabel(labelText, 0);
        this.addLabeledComponent(label, component, Fill.NONE);
    }

    public void addSeparator(int colspan) {
        this.addSeparator(colspan, "  ");
    }

    public void addSeparator(int colspan, String text) {
        JLabel label = new JLabel(text);
        Dimension size = label.getPreferredSize();
        size.setSize(size.getWidth() * 1.5, size.getHeight() * 1.5);
        label.setPreferredSize(size);
        label.setForeground(Color.darkGray);
        label.setBorder(new BottomEtchedBorder());
        this.addComponent(label, new Colspan(colspan), Rowspan.RS_1, Anchor.WEST, Fill.HORIZONTAL);
        this.incrRow();
    }

    public void addVerticalGlue() {
        JLabel label = new JLabel("");
        this.cell.nextRow();
        this.addComponent(label, new Colspan(this.maxCol + 1), Rowspan.RS_1, Anchor.CENTER, Fill.BOTH);
    }

    public void addVerticalGlue(int height) {
        JLabel label = new JLabel();
        Dimension dim = new Dimension(96, height);
        label.setMinimumSize(dim);
        label.setPreferredSize(dim);
        label.setMaximumSize(dim);
        this.cell.nextRow();
        this.addComponent(label, new Colspan(this.maxCol + 1), Rowspan.RS_1, Anchor.CENTER, Fill.HORIZONTAL);
    }

    public void appendToRow(int rowNum, JComponent comp) {
        Component[] compList = this.getComponents();
        int nr = 0;
        for (Component child : compList) {
            if (child instanceof GridPanel && nr == rowNum) {
                GridPanel rowPanel = (GridPanel)child;
                rowPanel.addComponent(comp);
            }
            ++nr;
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public GridCell getLastCell() {
        return this.cell;
    }

    public void incrRow() {
        if (this.rowPanel != null) {
            this.rowPanel.incrRow();
        } else {
            this.cell.nextRow();
            this.cell.setCol(this.columnOffset);
        }
    }

    public void leaveSubPanel() {
        this.rowPanel = null;
    }

    public void lock() {
        GridPanel.lock(this, false);
    }

    public void prepare() {
        if (this.buttonList != null && this.buttonList.size() > 0) {
            this.addVerticalGlue();
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(2));
            buttonPanel.setBorder(new TopEtchedBorder());
            for (JButton button : this.buttonList) {
                buttonPanel.add(button);
            }
            this.cell.setRow(this.maxRow + 1);
            this.cell.setCol(0);
            this.addComponent(buttonPanel, new Colspan(this.maxCol + 1), Rowspan.RS_1, Anchor.CENTER, Fill.HORIZONTAL);
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.setCell(0, 0);
    }

    public void replaceComponent(JComponent oldComponent, JComponent newComponent) {
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints gbc = layout.getConstraints(oldComponent);
        this.remove(oldComponent);
        this.add((Component)newComponent, gbc);
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void setColumnOffset(int columnOffset) {
        this.columnOffset = columnOffset;
        this.cell.setCol(columnOffset);
    }

    public void setGradientBackground(Color gradientFrom, Color gradientTo) {
        this.gradientFrom = gradientFrom;
        this.gradientTo = gradientTo;
    }

    public void setLock(boolean flag) {
        GridPanel.lock(this, flag);
    }

    public void setShowCellBorders(boolean showCellBorders) {
        Component[] compList = this.getComponents();
        Border border = null;
        if (showCellBorders) {
            border = BorderFactory.createLineBorder(Color.black, 2);
        }
        for (int i = 0; i < compList.length; ++i) {
            if (!(compList[i] instanceof JComponent)) continue;
            ((JComponent)compList[i]).setBorder(border);
        }
    }

    public void startSubPanel() {
        this.startSubPanel(Fill.NONE);
    }

    public void startSubPanel(Fill fill) {
        if (this.rowPanel != null) {
            this.rowPanel.addHorizontalGlue();
            this.rowPanel = null;
        }
        if (this.cell.getCol() != 0) {
            this.incrRow();
        }
        GridPanel panel = new GridPanel();
        this.addComponent((JComponent)panel, Anchor.WEST, fill, new Insets(0, 0, 0, 0));
        this.rowPanel = panel;
    }

    public void unlock() {
        GridPanel.lock(this, true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundImage != null) {
            g.drawImage(this.backgroundImage, 0, 0, null);
        } else if (this.gradientFrom != null && this.gradientTo != null) {
            GradientPaint paint = new GradientPaint(width / 2, 0.0f, this.gradientFrom, width / 2, height, this.gradientTo, true);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, width, height);
        } else {
            super.paintComponent(g);
        }
    }

    protected void setCell(int row, int col) {
        this.cell.setRow(row);
        this.cell.setCol(col);
    }
}

