/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Colspan;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.JiveServices;
import org.dbdoclet.jive.Rowspan;
import org.dbdoclet.jive.widget.FileSystemTree;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.jive.widget.fstree.FileSystemTreeNode;

public class FileSystemPanel
extends GridPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton upButton;
    private JLabel titleLabel;
    private FileSystemTree fileSystemTree;

    public FileSystemPanel() {
        super(new Insets(0, 0, 0, 0));
        File[] roots = File.listRoots();
        FileSystemTreeNode root = new FileSystemTreeNode(roots);
        this.init(root);
    }

    public FileSystemPanel(File dir) {
        super(new Insets(0, 0, 0, 0));
        FileSystemTreeNode root = new FileSystemTreeNode(new File[]{dir});
        this.init(root);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
        this.titleLabel.setVisible(true);
    }

    private void init(FileSystemTreeNode root) {
        JiveFactory jf = JiveFactory.getInstance();
        this.titleLabel = jf.createLabel(null, "");
        Font titleFont = this.titleLabel.getFont();
        titleFont = titleFont.deriveFont((float)titleFont.getSize() * 1.2f);
        this.titleLabel.setBackground(Color.WHITE);
        this.titleLabel.setFont(titleFont);
        int borderSize = this.getFont().getSize();
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize, borderSize, borderSize));
        this.titleLabel.setOpaque(true);
        this.titleLabel.setVisible(false);
        this.addComponent((JComponent)this.titleLabel, Anchor.CENTER, Fill.HORIZONTAL);
        this.incrRow();
        this.startSubPanel();
        this.upButton = jf.createIconButton(null, JiveServices.getJlfgrIcon("navigation", "Up24.gif"));
        this.upButton.setActionCommand("up");
        this.upButton.addActionListener(this);
        this.addComponent(this.upButton);
        this.leaveSubPanel();
        this.incrRow();
        this.fileSystemTree = new FileSystemTree(root);
        JScrollPane scrollPane = new JScrollPane(this.fileSystemTree);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createBevelBorder(1)));
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.addComponent(scrollPane, Colspan.CS_1, Rowspan.RS_1, Anchor.NORTHWEST, Fill.BOTH);
    }

    public File getSelectedFile() {
        TreePath treePath = this.fileSystemTree.getSelectionPath();
        if (treePath != null) {
            return ((FileSystemTreeNode)treePath.getLastPathComponent()).getFile();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd == null) {
            return;
        }
        if (cmd.equals("up")) {
            DefaultTreeModel model = (DefaultTreeModel)this.fileSystemTree.getModel();
            FileSystemTreeNode root = (FileSystemTreeNode)model.getRoot();
            root = (FileSystemTreeNode)root.getChildAt(0);
            File rootFile = root.getFile();
            File parentFile = rootFile.getParentFile();
            if (!rootFile.isDirectory() && parentFile != null) {
                parentFile = parentFile.getParentFile();
            }
            if (parentFile != null) {
                FileSystemTreeNode node = new FileSystemTreeNode(new File[]{parentFile});
                model.setRoot(node);
                model.nodeStructureChanged(node);
                this.fileSystemTree.expandFirstChild();
            }
        }
    }
}

