/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.widget.ActionClose;
import org.dbdoclet.jive.widget.EditorPanel;

public class Editor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private AbstractAction closeAction;
    private EditorPanel editorPanel;
    private boolean initialized;
    private AbstractAction saveAction;
    private JMenuItem saveButton;

    public void createGui() {
        JiveFactory jf = JiveFactory.getInstance();
        jf.getResourceBundle();
        this.setTitle("Editor");
        this.setJMenuBar(this.createMenuBar(jf));
        this.editorPanel = new EditorPanel();
        this.getContentPane().add(this.editorPanel);
        this.pack();
        this.initialized = true;
        this.closeAction = new ActionClose(jf.getResourceBundle().getString("C_SAVE"), this);
    }

    public String getText() {
        return this.editorPanel.getText();
    }

    public boolean isChanged() {
        return this.editorPanel.isChanged();
    }

    public void open(String buffer) {
        if (!this.initialized) {
            this.createGui();
        }
        this.editorPanel.setText(buffer);
    }

    public void save() {
        this.saveButton.doClick();
        this.editorPanel.setChanged(false);
    }

    public void setChanged(boolean changed) {
        this.editorPanel.setChanged(changed);
    }

    public void setSaveAction(AbstractAction saveAction) {
        this.saveAction = saveAction;
    }

    private JMenuBar createMenuBar(JiveFactory jf) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = jf.createMenu(jf.getResourceBundle().getString("C_FILE"));
        menuBar.add(fileMenu);
        this.saveButton = null;
        this.saveButton = this.saveAction != null ? jf.createMenuItem(new Identifier("editor.save"), this.saveAction) : jf.createMenuItem(new Identifier("editor.save"), jf.getResourceBundle().getString("C_SAVE"));
        fileMenu.add(this.saveButton);
        fileMenu.add(jf.createMenuItem(new Identifier("editor.close"), this.closeAction));
        return menuBar;
    }
}

