/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;

public class ButtonPanel
extends GridPanel {
    private static final long serialVersionUID = 1L;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CLOSE = 4;
    public static final int HELP = 8;
    public static final int SAVE = 16;
    public static final int EXPORT = 32;
    public static final int IMPORT = 64;
    public static final int PRINT = 128;
    public static final int CSV_EXPORT = 256;
    public static final int YES = 512;
    public static final int NO = 1024;
    private int flags = 3;
    private JiveFactory wm;
    private ResourceBundle res;
    private JButton cancelButton;
    private JButton okButton;
    private JButton saveButton;
    private JButton exportButton;
    private JButton importButton;
    private JButton printButton;
    private JButton csvExportButton;
    private JButton yesButton;
    private JButton noButton;
    private ActionListener listener;

    public ButtonPanel(int flags, ActionListener listener) {
        this.flags = flags;
        this.listener = listener;
        this.wm = JiveFactory.getInstance();
        this.res = this.wm.getResourceBundle();
        this.init();
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getYesButton() {
        return this.yesButton;
    }

    public JButton getNoButton() {
        return this.noButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getExportButton() {
        return this.exportButton;
    }

    public JButton getCsvExportButton() {
        return this.csvExportButton;
    }

    public JButton getImportButton() {
        return this.importButton;
    }

    public JButton getPrintButton() {
        return this.printButton;
    }

    private void init() {
        if ((this.flags & 1) == 1) {
            this.okButton = this.wm.createButton(new Identifier("button-panel.ok"), ResourceServices.getString(this.res, "C_OK"));
            this.okButton.setActionCommand("ok");
            this.okButton.addActionListener(this.listener);
            this.okButton.setMnemonic(79);
            this.addComponent(this.okButton);
        }
        if ((this.flags & 2) == 2) {
            this.cancelButton = this.wm.createButton(new Identifier("button-panel.cancel"), ResourceServices.getString(this.res, "C_CANCEL"));
            this.cancelButton.setActionCommand("cancel");
            this.cancelButton.addActionListener(this.listener);
            this.cancelButton.setMnemonic(67);
            this.addComponent(this.cancelButton);
        }
        if ((this.flags & 0x200) == 512) {
            this.yesButton = this.wm.createButton(new Identifier("button-panel.yes"), ResourceServices.getString(this.res, "C_YES"));
            this.yesButton.setActionCommand("yes");
            this.yesButton.addActionListener(this.listener);
            this.yesButton.setMnemonic(89);
            this.addComponent(this.yesButton);
        }
        if ((this.flags & 0x400) == 1024) {
            this.noButton = this.wm.createButton(new Identifier("button-panel.no"), ResourceServices.getString(this.res, "C_NO"));
            this.noButton.setActionCommand("no");
            this.noButton.addActionListener(this.listener);
            this.noButton.setMnemonic(78);
            this.addComponent(this.noButton);
        }
        if ((this.flags & 0x10) == 16) {
            this.saveButton = this.wm.createButton(new Identifier("button-panel.save"), ResourceServices.getString(this.res, "C_SAVE"));
            this.saveButton.setActionCommand("save");
            this.saveButton.addActionListener(this.listener);
            this.saveButton.setMnemonic(83);
            this.addComponent(this.saveButton);
        }
        if ((this.flags & 0x20) == 32) {
            this.exportButton = this.wm.createButton(new Identifier("button-panel.export"), ResourceServices.getString(this.res, "C_EXPORT"));
            this.exportButton.setActionCommand("export");
            this.exportButton.addActionListener(this.listener);
            this.exportButton.setMnemonic(69);
            this.addComponent(this.exportButton);
        }
        if ((this.flags & 0x40) == 64) {
            this.importButton = this.wm.createButton(new Identifier("button-panel.import"), ResourceServices.getString(this.res, "C_IMPORT"));
            this.importButton.setActionCommand("import");
            this.importButton.addActionListener(this.listener);
            this.importButton.setMnemonic(73);
            this.addComponent(this.importButton);
        }
        if ((this.flags & 0x100) == 256) {
            this.csvExportButton = this.wm.createButton(new Identifier("button-panel.csv-export"), ResourceServices.getString(this.res, "C_CSV_EXPORT"));
            this.csvExportButton.setActionCommand("csv-export");
            this.csvExportButton.addActionListener(this.listener);
            this.csvExportButton.setMnemonic(67);
            this.addComponent(this.csvExportButton);
        }
        if ((this.flags & 0x80) == 128) {
            this.printButton = this.wm.createButton(new Identifier("button-panel.print"), ResourceServices.getString(this.res, "C_PRINT"));
            this.printButton.setActionCommand("print");
            this.printButton.addActionListener(this.listener);
            this.printButton.setMnemonic(80);
            this.addComponent(this.printButton);
        }
    }
}

