/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.widget;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.ContinueDialog;
import org.dbdoclet.jive.dialog.ExceptionBox;
import org.dbdoclet.jive.widget.Editor;
import org.dbdoclet.service.ResourceServices;

class ActionClose
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Editor editor;

    public ActionClose(String name, Editor editor) {
        super(name);
        this.editor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            JiveFactory jf = JiveFactory.getInstance();
            ResourceBundle res = jf.getResourceBundle();
            if (this.editor.isChanged()) {
                ContinueDialog dlg = new ContinueDialog((Frame)this.editor, ResourceServices.getString(res, "C_SAVE"), ResourceServices.getString(res, "C_SAVE_BEFORE_EXIT"));
                dlg.setCancelButtonText(ResourceServices.getString(res, "C_DONT_SAVE"));
                dlg.setContinueButtonText(ResourceServices.getString(res, "C_SAVE"));
                dlg.setVisible(true);
                if (dlg.doContinue()) {
                    this.editor.save();
                }
            } else {
                this.editor.setVisible(false);
                this.editor.dispose();
            }
        }
        catch (Throwable oops) {
            ExceptionBox ebox = new ExceptionBox(oops);
            ebox.setVisible(true);
        }
    }
}

