/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.verifier;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;

public class FileVerifier
extends InputVerifier {
    private static Log logger = LogFactory.getLog(FileVerifier.class);
    private final File refFile;

    public FileVerifier(ResourceBundle res, File refFile) {
        if (res == null) {
            throw new IllegalArgumentException("Parameter res is null!");
        }
        this.refFile = refFile;
    }

    @Override
    public boolean verify(JComponent input) {
        if (input == null) {
            throw new IllegalArgumentException("Parameter input is null!");
        }
        if (input instanceof JTextField) {
            File parent;
            JTextField entry = (JTextField)input;
            String path = entry.getText();
            logger.debug((Object)("path #1 = " + path));
            if (path == null || path.length() == 0) {
                return true;
            }
            if (path.matches("^.*\\$\\{.*\\}.*$")) {
                return true;
            }
            if (!FileServices.isAbsolutePath(path) && this.refFile != null && (parent = this.refFile.getParentFile()) != null) {
                path = FileServices.appendPath(parent.getAbsolutePath(), path);
            }
            logger.debug((Object)("path #2 = " + path));
            File file = new File(path);
            return file.isFile();
        }
        return false;
    }
}

