/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.text.xml;

import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.ExceptionBox;
import org.dbdoclet.jive.text.xml.XmlEditorKit;

public class XmlEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTextPane editor;
    private XmlEditorKit kit;

    public XmlEditor() {
        super("XML Editor");
        JiveFactory.getInstance(Locale.getDefault());
        this.editor = new JTextPane();
        this.kit = new XmlEditorKit();
        this.editor.setEditorKit(this.kit);
        JScrollPane scrollPane = new JScrollPane(this.editor);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.pack();
        this.setSize(600, 600);
    }

    private void open(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("The parameter fileName must not be null!");
        }
        try {
            File file = new File(fileName);
            this.editor.read(new FileReader(file), (Object)file);
        }
        catch (Throwable oops) {
            ExceptionBox ebox = new ExceptionBox(oops);
            ebox.setVisible(true);
            ebox.toFront();
        }
    }

    public static void main(String[] args) {
        try {
            XmlEditor frame = new XmlEditor();
            frame.open(args[0]);
            frame.setVisible(true);
        }
        catch (Throwable oops) {
            ExceptionBox ebox = new ExceptionBox(oops);
            ebox.setVisible(true);
            ebox.toFront();
        }
    }
}

