/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.text.xml;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class XmlDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 1L;

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.highlight();
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this.trace("insertString: str=" + str);
        super.insertString(offset, str, a);
        this.highlight();
    }

    private void highlight() {
        int length = this.getLength();
        String text = "";
        try {
            text = this.getText(0, length);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        SimpleAttributeSet keyword = new SimpleAttributeSet();
        StyleConstants.setForeground(keyword, Color.blue);
        StyleConstants.setBold(keyword, true);
        SimpleAttributeSet normal = new SimpleAttributeSet();
        StyleConstants.setForeground(normal, Color.black);
        StyleConstants.setBold(normal, true);
        this.setCharacterAttributes(0, length, normal, true);
        int start = 0;
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) == '<') {
                start = i;
            }
            if (text.charAt(i) != '>') continue;
            int end = i;
            this.setCharacterAttributes(start, end - start, keyword, true);
        }
    }

    private void trace(String str) {
    }
}

