/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.text;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.text.IConsole;
import org.dbdoclet.service.ResourceServices;

public class TextConsole
extends JTextArea
implements IConsole {
    private static final String FONT_FAMILY = "Courier New";
    private static final long serialVersionUID = 1L;
    private int cols = 40;
    private Font font = new Font("Courier New", 0, 12);
    private ResourceBundle res;
    private int rows = 25;

    public TextConsole(int cols, int rows) {
        super(cols, rows);
        JiveFactory widgetMap = JiveFactory.getInstance();
        this.res = widgetMap.getResourceBundle();
        this.setFont(this.font);
        if (cols < 1 || cols > 500) {
            cols = 40;
        }
        if (rows < 1) {
            rows = 25;
        }
        this.cols = cols;
        this.rows = rows;
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public void clear() {
        try {
            Document doc = this.getDocument();
            if (doc != null) {
                doc.remove(0, doc.getLength());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void error(String text) {
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.error(ResourceServices.getString(this.res, "C_ERROR"), text);
    }

    public void error(String label, String text) {
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.append("[" + label + "] ");
        this.append(text);
        this.seeEnd();
    }

    @Override
    public void exception(Throwable oops) {
        this.exception(oops, null);
    }

    public void exception(Throwable oops, String buffer) {
        String text = "[Exception] Class: " + oops.getClass().getName();
        String msg = oops.getMessage();
        if (msg != null && msg.length() > 0) {
            text = text + " Message: " + msg;
        }
        if (buffer != null) {
            text = text + buffer;
        }
        StringWriter stack = new StringWriter();
        oops.printStackTrace(new PrintWriter(stack));
        text = text + "\n===================\n" + stack.toString();
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.append(text);
        this.seeEnd();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        Graphics graphics = this.getGraphics();
        FontMetrics metrics = graphics.getFontMetrics(this.font);
        double minWidth = metrics.charWidth('m') * this.cols;
        double minHeight = metrics.getHeight() * this.rows;
        double width = dim.getWidth();
        double height = dim.getHeight();
        if (width < minWidth) {
            width = minWidth;
        }
        if (height < minHeight) {
            height = minHeight;
        }
        dim.setSize(width, height);
        return dim;
    }

    @Override
    public void info(String text) {
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.append(text);
        this.seeEnd();
    }

    public void message(String text) {
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.append(text);
        this.seeEnd();
    }

    public void println(String text) {
        this.message(text);
    }

    @Override
    public void section(String text) {
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.append(text);
        this.seeEnd();
    }

    public void seeEnd() {
        this.setCaretPosition(this.getText().length() - 1);
    }

    public void warning(String text) {
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.append(text);
        this.seeEnd();
    }
}

