/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.text;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.dbdoclet.io.Screen;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.text.ScreenPane;
import org.dbdoclet.service.ResourceServices;

public class Terminal
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ResourceBundle res;
    private ScreenPane screen;
    private boolean hasCloseButton;

    public Terminal(boolean hasCloseButton, Dimension preferredSize) {
        this.hasCloseButton = hasCloseButton;
        JiveFactory widgetMap = JiveFactory.getInstance();
        this.res = widgetMap.getResourceBundle();
        this.screen = new ScreenPane();
        this.screen.setPreferredSize(preferredSize);
        this.screen.setMinimumSize(new Dimension(40, 10));
        this.screen.setAlignmentX(0.5f);
        JScrollPane scrollPane = new JScrollPane(this.screen);
        this.setLayout(new BoxLayout(this, 1));
        this.add(scrollPane);
        this.add(Box.createRigidArea(new Dimension(0, 4)));
        if (hasCloseButton) {
            JButton closeButton = new JButton(ResourceServices.getString(this.res, "C_CLOSE"));
            closeButton.setActionCommand("close");
            closeButton.addActionListener(this);
            closeButton.setAlignmentX(0.5f);
            this.add(closeButton);
        }
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public Terminal() {
        this(false, new Dimension(700, 100));
    }

    public Terminal(boolean hasCloseButton) {
        this(hasCloseButton, new Dimension(700, 100));
    }

    public Terminal(Dimension dim) {
        this(false, dim);
    }

    @Override
    public void setPreferredSize(Dimension dim) {
        super.setSize(dim);
        Dimension screenDim = this.hasCloseButton ? new Dimension(dim.width - 5, dim.height - 20) : new Dimension(dim.width - 5, dim.height - 5);
        this.screen.setSize(screenDim);
    }

    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("close")) {
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof Window)) continue;
                Window wnd = (Window)parent;
                wnd.setVisible(false);
                wnd.dispose();
                break;
            }
        }
    }
}

