/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.io.Screen;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.service.ResourceServices;

public class ScreenPane
extends JTextPane
implements Screen {
    private static final String FONT_FAMILY = "Monospaced";
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(ScreenPane.class);
    private final ResourceBundle res;
    private Font font;
    private Style regular;
    private Style error;
    private Style errorLabel;
    private Style warning;
    private Style exception;
    private Style section;
    private Style command;
    private int cols = 40;
    private int rows = 25;
    private final int maxLength = 0x100000;

    public ScreenPane(Font font, int cols, int rows) {
        JiveFactory widgetMap = JiveFactory.getInstance();
        this.res = widgetMap.getResourceBundle();
        if (font == null) {
            font = new Font(FONT_FAMILY, 0, 12);
        }
        this.setFont(font);
        if (cols < 1 || cols > 500) {
            cols = 40;
        }
        if (rows < 1) {
            rows = 25;
        }
        this.font = font;
        this.cols = cols;
        this.rows = rows;
        this.setEditable(false);
    }

    public ScreenPane(Font font) {
        this(font, 40, 25);
    }

    public ScreenPane() {
        this(new Font(FONT_FAMILY, 0, 12), 40, 25);
    }

    public ScreenPane(int width, int height) {
        this(new Font(FONT_FAMILY, 0, 12), width, height);
    }

    @Override
    public void clear() {
        try {
            Document doc = this.getDocument();
            if (doc != null) {
                doc.remove(0, doc.getLength());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void println(String text) {
        this.message(text);
    }

    public void append(String text) {
        if (text == null) {
            text = "";
        }
        this.append(text, this.getStyle("regular"));
    }

    public void append(String text, Style style) {
        if (text == null) {
            text = "";
        }
        if (style == null) {
            throw new IllegalArgumentException("Parameter style is null!");
        }
        this.append(text, style, true);
    }

    public void append(String text, Style style, boolean appendLinefeed) {
        if (text == null) {
            text = "";
        }
        if (style == null) {
            throw new IllegalArgumentException("Parameter style is null!");
        }
        try {
            Document doc = this.getDocument();
            if (doc == null) {
                throw new NullPointerException("Variable doc is null!");
            }
            if (appendLinefeed) {
                text = text + "\n";
            }
            doc.insertString(doc.getLength(), text, style);
            this.seeEnd();
        }
        catch (BadLocationException oops) {
            oops.printStackTrace();
        }
    }

    public void appendSpace() {
        try {
            Document doc = this.getDocument();
            if (doc == null) {
                throw new NullPointerException("Variable doc is null!");
            }
            int length = doc.getLength();
            doc.insertString(length, " ", this.regular);
        }
        catch (BadLocationException oops) {
            oops.printStackTrace();
        }
    }

    @Override
    public void exception(Throwable oops) {
        this.exception(oops, null);
    }

    @Override
    public void exception(Throwable oops, String buffer) {
        String text = "[Exception] Class: " + oops.getClass().getName();
        String msg = oops.getMessage();
        if (msg != null && msg.length() > 0) {
            text = text + " Message: " + msg;
        }
        if (buffer != null) {
            text = text + buffer;
        }
        StringWriter stack = new StringWriter();
        oops.printStackTrace(new PrintWriter(stack));
        text = text + "\n===================\n" + stack.toString();
        this.append(text, this.getStyle("exception"));
    }

    @Override
    public void command(String text) {
        this.append(text, this.getStyle("command"));
    }

    @Override
    public void error(String text) {
        this.error(ResourceServices.getString(this.res, "C_ERROR"), text);
    }

    @Override
    public void error(String label, String text) {
        this.append("[" + label + "]", this.getStyle("errorLabel"), false);
        this.appendSpace();
        this.append(text, this.getStyle("error"));
    }

    @Override
    public void warning(String text) {
        this.append(text, this.getStyle("warning"));
    }

    @Override
    public void section(String text) {
        this.append(text, this.getStyle("section"));
    }

    @Override
    public void message(String text) {
        this.append(text, this.getStyle("regular"));
    }

    @Override
    public void info(String text) {
        Document doc = this.getDocument();
        if (doc.getLength() > 0x100000) {
            try {
                doc.remove(0, text.length());
            }
            catch (BadLocationException oops) {
                logger.fatal((Object)oops);
            }
        }
        this.append(text, this.getStyle("regular"));
    }

    public void seeEnd() {
        Document doc = this.getDocument();
        if (doc == null) {
            throw new NullPointerException("Variable doc is null!");
        }
        int length = doc.getLength();
        this.setCaretPosition(length);
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Parameter font is null!");
        }
        this.font = font;
        StyledDocument doc = this.getStyledDocument();
        if (doc == null) {
            return;
        }
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        if (def != null) {
            StyleConstants.setFontFamily(def, font.getFamily());
            StyleConstants.setFontSize(def, font.getSize());
            this.regular = this.addStyle("regular", def);
            this.command = this.addStyle("command", def);
            StyleConstants.setBackground(this.command, Color.lightGray);
            this.error = this.addStyle("error", def);
            StyleConstants.setForeground(this.error, Color.red);
            this.errorLabel = this.addStyle("errorLabel", def);
            StyleConstants.setForeground(this.errorLabel, Color.white);
            StyleConstants.setBackground(this.errorLabel, Color.red);
            this.warning = this.addStyle("warning", def);
            StyleConstants.setForeground(this.warning, Color.orange);
            this.exception = this.addStyle("exception", def);
            StyleConstants.setForeground(this.exception, Color.red);
            StyleConstants.setBold(this.exception, true);
            this.section = this.addStyle("section", def);
            StyleConstants.setSpaceAbove(this.section, 2.0f);
            StyleConstants.setUnderline(this.section, true);
            StyleConstants.setBold(this.section, true);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        Graphics graphics = this.getGraphics();
        FontMetrics metrics = graphics.getFontMetrics(this.font);
        double minWidth = metrics.charWidth('m') * this.cols;
        double minHeight = metrics.getHeight() * this.rows;
        double width = dim.getWidth();
        double height = dim.getHeight();
        if (width < minWidth) {
            width = minWidth;
        }
        if (height < minHeight) {
            height = minHeight;
        }
        dim.setSize(width, height);
        return dim;
    }
}

