/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.dbdoclet.jive.fo.FoAttributeSet;
import org.dbdoclet.jive.sheet.AbstractPart;
import org.dbdoclet.unit.Length;

public class ChangeTextEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private final FoAttributeSet oldAttributeSet;
    private final FoAttributeSet newAttributeSet;
    private final AbstractPart text;

    public ChangeTextEdit(AbstractPart text, FoAttributeSet oldAttributeSet, FoAttributeSet newAttributeSet) {
        this.text = text;
        this.oldAttributeSet = oldAttributeSet;
        this.newAttributeSet = newAttributeSet;
    }

    @Override
    public String getPresentationName() {
        return this.getClass().getSimpleName() + ": Alte Schriftart=" + this.oldAttributeSet.getFontFamily() + ", neue Schriftart=" + this.newAttributeSet.getFontFamily();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.setFontAttributes(this.newAttributeSet);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.setFontAttributes(this.oldAttributeSet);
    }

    private void setFontAttributes(FoAttributeSet attributeSet) {
        this.text.setFont(attributeSet.getFont());
        this.text.setMarginTop(Length.valueOf(attributeSet.getSpaceBeforeOptimum()));
        this.text.setMarginBottom(Length.valueOf(attributeSet.getSpaceAfterOptimum()));
        this.text.getSheet().updateView();
    }
}

