/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.sheet.undo;

import java.util.ArrayList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.dbdoclet.jive.sheet.Part;
import org.dbdoclet.jive.sheet.undo.ChangePartData;

public class ChangePartEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private ArrayList<ChangePartData> editList = new ArrayList();

    public void addEditData(Part oldPart, Part part) {
        this.editList.add(new ChangePartData(oldPart, part.deepCopy(part.getSheet()), part));
    }

    @Override
    public String getPresentationName() {
        return this.getClass().getSimpleName() + ": EditList[" + this.editList + "]";
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (ChangePartData data : this.editList) {
            this.copyProperties(data.getNewPart(), data.getRefPart());
            data.getRefPart().getSheet().updateView();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (ChangePartData data : this.editList) {
            this.copyProperties(data.getOldPart(), data.getRefPart());
            data.getRefPart().getSheet().updateView();
        }
    }

    private void copyProperties(Part fromPart, Part toPart) {
        fromPart.copyProperties(toPart);
    }
}

